/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.command;

import javax.ide.menu.IDEAction;

/**
 * <tt>UpdateHandler</tt>s decide when actions are enabled or disabled based
 * on a context. 
 */
public interface UpdateHandler 
{
  /**
   * Update the specified action based on the specified context. Typically an
   * implementation will evaluate the <tt>context</tt> and enable or disable
   * the action using {@link IDEAction#setEnabled( boolean )}.
   * 
   * @param action the action to update. 
   * @param context the context to use for the update.
   * 
   * @return true if this handler changed the state of the action.
   */
  boolean update( IDEAction action, Context context );
}
