/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.build;

/**
 * Exception thrown by {@link BuildListener}s to stop the build process.
 */
public class AbortBuildException extends Exception
{
  /**
   * Constructs an <tt>AbortBuildException</tt>.
   *
   * @param msg a short message indicating the problem.
   */
  public AbortBuildException( String msg )
  {
    super( msg );
  }

  /**
   * Constructs an <tt>AbortBuildException</tt>.
   *
   * @param msg a short message indicating the problem.
   * @param cause another exception which caused this exception.
   */  
  public AbortBuildException( String msg, Throwable cause )
  {
    super( msg, cause );
  }
}
