/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide;

import java.util.EventListener;

/**
 * Extension writers request notification of IDE events by implementing
 * this interface and registering their IDE listener with the extension
 * deployment descriptor.
 */
public interface IDEListener extends EventListener
{
  /**
   * Notify listeners that IDE application window has become the active
   * application.
   * @param event the {@link IDEEvent} object.
   */
  public void activated( IDEEvent event );

  /**
   * Notify listeners that IDE application window has stopped being the active
   * application.
   * @param event the {@link IDEEvent} object.
   */
  public void deactivated( IDEEvent event );
}
