/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide;

import java.util.EventObject;

/**
 * The IDEEvent is the parameter passed to the {@link IDEListener} 
 * methods when the active state of the IDE application has changed. <p>
 *
 * The <code>IDEEvent</code> source is the IDE instance whose state 
 * is changing. The convenience method {@link #getIDE} can be used to 
 * retrieve the IDE instance.
 */
public final class IDEEvent extends EventObject
{
  /**
   * Constructor.
   *
   * @param ide the IDE where the event happened.
   */
  public IDEEvent( IDE ide )
  {
    super(ide);
  }

  /**
   * Get the {@link IDE} where the event happened.
   * This is functionally equivalent to casting the result of getSource() to 
   * a <code>IDE</code> object.
   *
   * @return the {@link IDE} whose state has changed.
   */
  public IDE getIDE() 
  {
    return (IDE)getSource();
  }
}
