/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.Preferences;
import oracle.ide.config.SettingsCustomizations;
import oracle.ide.config.SettingsFieldCustomizations;
import oracle.ide.config.SettingsUICustomizationsHook;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.style.CodeStyleHook;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.CodingStyleProfiles;

public class ProfileRepository {
    private static final String DEFAULT_PROFILE_NAME = "Java Code Conventions";
    private static ProfileRepository instance;
    private CodingStyleProfiles profiles;
    private Map<String, CodingStyleProfile> defaultProfileMap;

    private ProfileRepository() {
    }

    public static synchronized ProfileRepository getProfileRepository() {
        if (instance == null) {
            instance = new ProfileRepository();
        }
        return instance;
    }

    public synchronized CodingStyleProfile getProfile(String name) {
        this.loadProfiles();
        return this.profiles.getProfile(name);
    }

    public synchronized boolean contains(String name) {
        this.loadProfiles();
        return this.profiles.containsKey(name);
    }

    public synchronized List<CodingStyleProfile> getProfiles() {
        this.loadProfiles();
        return Collections.unmodifiableList(new ArrayList<CodingStyleProfile>(this.profiles.getProfileMap().values()));
    }

    public synchronized void addProfile(CodingStyleProfile profile, boolean isDefault) {
        String name = profile.getName();
        if (name == null) {
            throw new IllegalArgumentException("Profile must have a name");
        }
        this.loadProfiles();
        if (this.profiles.containsKey(name)) {
            if (!isDefault) {
                CodingStyleProfile existing = this.profiles.getProfile(name);
                profile.copyTo((Object)existing);
            }
        } else {
            this.profiles.putProfile(name, profile);
        }
        if (isDefault) {
            this.defaultProfileMap.put(profile.getName(), profile);
        }
    }

    public synchronized void addProfile(CodingStyleProfile profile) {
        this.addProfile(profile, false);
    }

    public synchronized void removeProfile(CodingStyleProfile profile) {
        this.profiles.removeProfile(profile.getName());
    }

    public synchronized CodingStyleProfile getDefaultProfile(String name) {
        this.loadProfiles();
        return this.defaultProfileMap.get(name);
    }

    public CodingStyleProfile getDefaultProfile() {
        String result;
        SettingsFieldCustomizations fields;
        SettingsCustomizations settings;
        SettingsUICustomizationsHook hook = (SettingsUICustomizationsHook)ExtensionRegistry.getExtensionRegistry().getHook(SettingsUICustomizationsHook.ELEMENT);
        if (hook != null && (settings = hook.getSettingsCustomizations()) != null && (fields = settings.getFieldCustomizations("/preferences/ceditor/style/CodingStylePreferences.profile")) != null && (result = fields.getValue()) != null) {
            CodingStyleProfile profile = this.getDefaultProfile(result);
            if (profile == null) {
                Logger.getLogger("global").log(Level.SEVERE, "CodingStyleProfile: no profile found for roleoverride: " + result);
            } else {
                return profile;
            }
        }
        return this.getDefaultProfile(DEFAULT_PROFILE_NAME);
    }

    private void loadProfiles() {
        if (this.profiles == null) {
            CodingStyleProfiles defaultProfiles = new CodingStyleProfiles();
            this.defaultProfileMap = defaultProfiles.getProfileMap();
            Preferences prefs = Preferences.getPreferences();
            boolean isInitialized = prefs.getProperties().containsKey("CodingStyleProfiles");
            this.profiles = CodingStyleProfiles.getInstance((PropertyStorage)prefs);
            if (!isInitialized) {
                defaultProfiles.copyTo((Object)this.profiles);
            }
            List<CodingStyleProfile> declarativeProfiles = CodeStyleHook.getProfiles();
            for (CodingStyleProfile declarativeProfile : declarativeProfiles) {
                this.addProfile(declarativeProfile, true);
            }
        }
    }
}

