/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.RegisteredByExtension;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.style.CodeFormatHook;
import oracle.jdevimpl.style.profile.CodingStyleProfile;

@RegisteredByExtension(value="oracle.jdeveloper.style")
public final class CodeStyleHook
extends HashStructureHook {
    private static List<CodingStyleProfile> profiles = new ArrayList<CodingStyleProfile>();
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "code-style");

    CodeStyleHook() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                CodeStyleHook.this.addProviders(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                CodeStyleHook.this.addProviders(e.getNewElementHashStructure());
            }
        });
    }

    public static CodeFormatHook get() {
        return (CodeFormatHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CodingStyleProfile> getProfiles() {
        List<CodingStyleProfile> list = profiles;
        synchronized (list) {
            return new ArrayList<CodingStyleProfile>(profiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProviders(HashStructure hs) {
        if (hs == null) {
            return;
        }
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        List listStruct = hs.getAsList("profile-url");
        if (listStruct == null) {
            return;
        }
        for (Object urlObj : listStruct) {
            HashStructure urlHash = (HashStructure)urlObj;
            String extensionId = CodeStyleHook.getExtensionId((HashStructure)urlHash);
            try {
                String urlString = CodeStyleHook.getText((HashStructure)urlHash);
                ClassLoader cl = extensionRegistry.getClassLoader(extensionId);
                String jarString = urlString.startsWith("/") ? urlString.substring(1) : urlString;
                URL entry = cl.getResource(jarString);
                if (entry != null) {
                    InputStreamReader reader = new InputStreamReader(entry.openStream());
                    try {
                        CodingStyleProfile profile = CodingStyleProfile.importFrom(reader);
                        List<CodingStyleProfile> list = profiles;
                        synchronized (list) {
                            profiles.add(profile);
                            continue;
                        }
                    }
                    finally {
                        ((Reader)reader).close();
                        continue;
                    }
                }
                Logger.getLogger("global").log(Level.WARNING, "CodingStyleHook: Could not load style profile for " + urlString + " (extension: " + extensionId + ")");
            }
            catch (Exception e) {
                extensionRegistry.getLogger().log(Level.WARNING, "Could not load declared template-url for extension: " + extensionId, e);
            }
        }
    }
}

