/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.macro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.Parameter;
import oracle.ide.externaltools.macro.ParameterizedMacro;
import oracle.ideimpl.externaltools.Util;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public class LazyParameterizedMacro
extends ParameterizedMacro {
    private HashStructure _hash;
    private ParameterizedMacro _instance;
    private Collection<Parameter> _supportedParameters;
    public static final String PARAMETER = "parameter";
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_LABEL = "label";

    public LazyParameterizedMacro(HashStructure hash) {
        this._hash = hash;
    }

    @Override
    public String getMacro() {
        return this._hash.getString("macro");
    }

    @Override
    public String getSampleExpansion(Context context) {
        if (this._instance == null) {
            if (Util.isProvidingExtensionAvailable(this._hash)) {
                return this.getInstance().getSampleExpansion(context);
            }
            return null;
        }
        return this._instance.getSampleExpansion(context);
    }

    @Override
    public String expand(Context context) {
        ParameterizedMacro macro = this.getInstance();
        if (macro == null) {
            return null;
        }
        Collection<Parameter> params = this.getSupportedParameters();
        if (params != Collections.EMPTY_LIST) {
            for (Parameter p : params) {
                macro.setValue(p, this.getValue(p));
            }
        }
        return macro.expand(context);
    }

    @Override
    public String getShortLabel() {
        return this._hash.getString(PARAMETER_NAME);
    }

    @Override
    public String getLongLabel() {
        return this._hash.getString("description");
    }

    @Override
    public String getToolTipText() {
        return this._hash.getString("tooltip");
    }

    @Override
    public boolean isDirectoryMacro() {
        return this._hash.getBoolean("isDirectoryMacro");
    }

    @Override
    public boolean isAvailableForType(ExternalToolType type) {
        return this.isAvailableForType(type.getId());
    }

    @Override
    public boolean isAvailableForType(String typeId) {
        String validTypeIds = this._hash.getString("validForTypes");
        if (ModelUtil.hasLength((String)validTypeIds)) {
            String[] types;
            for (String t : types = validTypeIds.split(",")) {
                if (!typeId.equals(t)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isParameterizedMacro() {
        return this.getSupportedParameters() == Collections.EMPTY_LIST;
    }

    @Override
    public Collection<Parameter> getSupportedParameters() {
        if (this._supportedParameters == null) {
            List hashList = this._hash.getAsList(PARAMETER);
            if (hashList == null || hashList.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            for (HashStructure h : hashList) {
                String pName = h.getString(PARAMETER_NAME);
                String pLabel = h.getString(PARAMETER_LABEL);
                params.add(new Parameter(pName, pLabel));
            }
            this._supportedParameters = params;
        }
        return this._supportedParameters;
    }

    private ParameterizedMacro getInstance() {
        if (this._instance == null) {
            this._instance = (ParameterizedMacro)LazyClassAdapter.getInstance((HashStructure)this._hash).createInstance(ParameterizedMacro.class, "implClass");
        }
        return this._instance;
    }
}

