/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.IntegrationPoint;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.data.HashStructure;

public final class Util {
    private Util() {
    }

    public static Icon getIcon(URL iconURL) {
        if (iconURL != null) {
            if (iconURL.getProtocol() != null && iconURL.getProtocol().startsWith("ide.fileicon")) {
                String path = URLFileSystem.getPath((URL)iconURL);
                File f = new File(path);
                if (f.isFile()) {
                    return FileSystemView.getFileSystemView().getSystemIcon(f);
                }
            } else {
                return new ImageIcon(iconURL);
            }
        }
        return null;
    }

    public static Icon getToolIcon(ExternalTool tool, Context context) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        Icon icon = Util.getIcon(props.getIconURL());
        if (icon == null) {
            icon = props.isIntegrated(IntegrationPoint.MAIN_TOOLBAR) ? tool.getIconWhenRequired() : IdeIcons.getIcon((int)23);
        }
        return icon;
    }

    public static boolean isProvidingExtensionAvailable(HashStructure hash) {
        String extensionId = hash.getString("#__extension-id");
        return ExtensionRegistry.getExtensionRegistry().isFullyLoaded(extensionId);
    }
}

