/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class RSAPublicKey
extends RSAKey
implements PublicKey {
    private AlgorithmIdentifier a;
    private ASN1Sequence b;
    private byte[] c;

    public RSAPublicKey() {
    }

    public RSAPublicKey(byte[] byArray) throws IOException {
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public RSAPublicKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    RSAPublicKey(BigInt bigInt, BigInt bigInt2) {
        super(bigInt, bigInt2);
    }

    public byte[] getEncoded() {
        FIPS_140_2.assertReadyState();
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = CryptoUtils.subjectPublicKeyInfo(this);
            this.c = Utils.toBytes(aSN1Sequence);
        }
        return this.c;
    }

    public boolean getAllowExport() {
        return true;
    }

    public String getFormat() {
        return "X.509";
    }

    public void erase() {
        super.erase();
        this.d();
    }

    public void finalize() {
        this.erase();
    }

    public Object clone() {
        BigInt bigInt;
        FIPS_140_2.assertReadyState();
        RSAPublicKey rSAPublicKey = new RSAPublicKey();
        try {
            if (this.a != null) {
                rSAPublicKey.a = new AlgorithmIdentifier(Utils.toStream(this.a));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        BigInt bigInt2 = this.b();
        if (bigInt2 != null) {
            bigInt2 = BigInt.getInstance(bigInt2);
        }
        if ((bigInt = this.c()) != null) {
            bigInt = BigInt.getInstance(bigInt);
        }
        rSAPublicKey.a(bigInt2, bigInt);
        return rSAPublicKey;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
        if (aSN1Object2 != null && !(aSN1Object2 instanceof ASN1Null)) {
            throw new AlgorithmIdentifierException();
        }
        this.a(aSN1Object);
        this.a = algorithmIdentifier;
    }

    private void a(ASN1Object aSN1Object) throws InvalidInputException {
        ASN1Sequence aSN1Sequence;
        try {
            aSN1Sequence = (ASN1Sequence)aSN1Object;
            BigInt bigInt = ((ASN1Integer)aSN1Sequence.elementAt(0)).getBigIntValue();
            BigInt bigInt2 = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            this.a(bigInt, bigInt2);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidInputException(arrayIndexOutOfBoundsException.toString());
        }
        this.a = null;
        this.d();
        this.b = aSN1Sequence;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            this.a = AlgID.rsaEncryption;
        }
        return this.a;
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        if (this.b == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.b()));
            aSN1Sequence.addElement(new ASN1Integer(this.c()));
            this.b = aSN1Sequence;
        }
        return this.b;
    }

    private void d() {
        this.c = null;
        this.b = null;
    }

    public boolean isPublic() {
        return true;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "{ modulus = " + this.b() + ", exponent = " + this.c() + " }";
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            if (aSN1Sequence.size() != 2) {
                throw new ASN1FormatException("Sequence has wrong number of components.");
            }
            if (aSN1Sequence.elementAt(0) instanceof ASN1Integer) {
                this.a(aSN1Sequence);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
                ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1BitString)aSN1Sequence.elementAt(1)).getValue());
                this.initialize(algorithmIdentifier, aSN1Object);
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public int length() {
        return this.getEncoded().length;
    }
}

