/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.math.BigInteger;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.k;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;

public final class RSA {
    private RSAKey a;

    public void setKey(RSAKey rSAKey) {
        FIPS_140_2.assertReadyState();
        k.a(rSAKey, 4096);
        this.a = rSAKey;
    }

    public BigInteger performOp(BigInteger bigInteger) {
        return new BigInteger(this.a(BigInt.getInstance(bigInteger)).toByteArray());
    }

    BigInt a(BigInt bigInt) {
        FIPS_140_2.assertReadyState();
        if (this.a instanceof RSAPublicKey) {
            return bigInt.modPow(this.a.c(), this.a.b());
        }
        if (this.a instanceof RSAPrivateKey) {
            BigInt bigInt2;
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.a;
            BigInt bigInt3 = rSAPrivateKey.b();
            BigInt bigInt4 = rSAPrivateKey.g();
            BigInt bigInt5 = rSAPrivateKey.h();
            BigInt bigInt6 = rSAPrivateKey.i();
            BigInt bigInt7 = rSAPrivateKey.j();
            BigInt bigInt8 = rSAPrivateKey.k();
            if (bigInt4 == null || bigInt5 == null || bigInt6 == null || bigInt7 == null || bigInt8 == null) {
                return bigInt.modPow(rSAPrivateKey.c(), bigInt3);
            }
            BigInt bigInt9 = bigInt.mod(bigInt4).modPow(bigInt6, bigInt4);
            BigInt bigInt10 = bigInt9.subtract(bigInt2 = bigInt.mod(bigInt5).modPow(bigInt7, bigInt5));
            if (bigInt10.signum() == -1) {
                bigInt10 = bigInt10.add(bigInt4);
            }
            bigInt10 = (bigInt10 = bigInt10.multiply(bigInt8)).signum() >= 0 ? bigInt10.mod(bigInt4) : bigInt4.subtract(bigInt10.negate().mod(bigInt4));
            if ((bigInt10 = bigInt10.multiply(bigInt5).add(bigInt2)).compareTo(bigInt3) >= 0) {
                bigInt10 = bigInt10.subtract(bigInt3);
            }
            return bigInt10;
        }
        throw new IllegalStateException("Unknown key class");
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

