/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.HMAC;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PBMacAlgID;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.fips.FIPS_140_2;

public class PasswordBasedMAC
extends MessageDigest {
    public static final int DEFAULT_SALT_LEN = 8;
    public static final AlgorithmIdentifier DEFAULT_OWF = AlgID.sha1;
    public static final int DEFAULT_ITER_COUNT = 1024;
    public static final AlgorithmIdentifier DEFAULT_MAC = AlgID.hmacSHA;
    private byte[] b;
    private AlgorithmIdentifier c;
    private int d;
    private AlgorithmIdentifier e;
    private RandomBitsSource f;
    private byte[] g;
    private byte[] h;
    private MessageDigest i;
    private MessageDigest j;
    private byte[] k;
    private boolean l;

    public PasswordBasedMAC() {
    }

    public PasswordBasedMAC(byte[] byArray) throws AlgorithmIdentifierException {
        this(AlgID.PasswordBasedMac, byArray);
    }

    public PasswordBasedMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws AlgorithmIdentifierException {
        this.setAlgID(algorithmIdentifier);
        this.setPassword(byArray);
    }

    public PasswordBasedMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        this.setRandomBitsSource(randomBitsSource);
        this.setAlgID(algorithmIdentifier);
        this.setPassword(byArray);
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        if (!aSN1ObjectID.equals(AlgID.PasswordBasedMac.getOID())) {
            throw new AlgorithmIdentifierException("Invalid algorithm OID: " + aSN1ObjectID);
        }
        ASN1Object aSN1Object = algorithmIdentifier.getParameters();
        if (aSN1Object != null) {
            PBMacAlgID pBMacAlgID = new PBMacAlgID(aSN1Object);
            this.b = pBMacAlgID.getSalt();
            this.c = pBMacAlgID.getOwfAlgID();
            this.d = pBMacAlgID.getCount().intValue();
            this.setMacAlgID(pBMacAlgID.getMacAlgID());
            this.a = pBMacAlgID;
        } else {
            if (this.f != null) {
                this.b = new byte[8];
                this.f.randomBytes(this.b);
            } else {
                this.b = null;
            }
            this.c = DEFAULT_OWF;
            this.d = 1024;
            this.e = DEFAULT_MAC;
        }
        this.h = null;
        this.i = MessageDigest.getInstance(this.c);
        this.j = MessageDigest.getInstance(this.e);
        this.k = new byte[this.j.getDigestLength()];
        this.l = false;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            if (this.d > 0 && this.e != null && this.c != null && this.b == null && this.f != null) {
                this.b = new byte[8];
                this.f.randomBytes(this.b);
            }
            if (this.b == null || this.c == null || this.d <= 0 || this.e == null) {
                return new PBMacAlgID();
            }
            try {
                this.a = new PBMacAlgID(this.b, this.c, BigInteger.valueOf(this.d), this.e);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
        return this.a;
    }

    public void setSalt(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        this.b = byArray;
        this.h = null;
        this.l = false;
    }

    public byte[] getSalt() {
        return this.b;
    }

    public void setOwfAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        this.c = algorithmIdentifier;
        this.h = null;
        this.l = false;
    }

    public AlgorithmIdentifier getOwfAlgID() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public void setCount(int n) {
        FIPS_140_2.assertReadyState();
        this.d = n;
        this.h = null;
        this.l = false;
    }

    public int getCount() {
        FIPS_140_2.assertReadyState();
        return this.d;
    }

    public void setMacAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        if (!aSN1ObjectID.equals(AlgID.hmacSHA.getOID()) && !aSN1ObjectID.equals(AlgID.hmacMD5.getOID())) {
            throw new AlgorithmIdentifierException("Unsupported MAC algorithm: " + aSN1ObjectID);
        }
        this.e = algorithmIdentifier;
    }

    public AlgorithmIdentifier getMacAlgID() {
        FIPS_140_2.assertReadyState();
        return this.e;
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.f = randomBitsSource;
    }

    public void setPassword(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        this.g = byArray;
        this.h = null;
        this.l = false;
    }

    private byte[] c() {
        if (this.b == null) {
            if (this.f == null) {
                this.f = RandomBitsSource.getDefault();
            }
            this.b = new byte[8];
            this.f.randomBytes(this.b);
        }
        byte[] byArray = new byte[this.i.getDigestLength()];
        this.i.init();
        this.i.update(this.g);
        this.i.update(this.b);
        this.i.computeCurrent();
        System.arraycopy(this.i.a(), 0, byArray, 0, this.i.a().length);
        for (int i2 = 1; i2 < this.d; ++i2) {
            System.arraycopy(this.i.computeDigest(byArray), 0, byArray, 0, this.i.a().length);
        }
        return byArray;
    }

    public void init() {
        FIPS_140_2.assertReadyState();
        try {
            if (this.i == null) {
                this.i = MessageDigest.getInstance(this.c);
            }
            if (this.j == null) {
                this.j = MessageDigest.getInstance(this.e);
                this.k = new byte[this.j.getDigestLength()];
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (this.h == null) {
            this.h = this.c();
            try {
                ((HMAC)this.j).initialize(this.e, new SymmetricKey(this.h, null));
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
        this.j.init();
        this.l = false;
    }

    public int blockSize() {
        return this.j.blockSize();
    }

    public void update(byte by) {
        this.j.update(by);
        this.l = false;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.j.update(byArray, n, n2);
        this.l = false;
    }

    public void computeCurrent() {
        this.j.computeCurrent();
        System.arraycopy(this.j.a(), 0, this.k, 0, this.k.length);
        this.l = true;
    }

    public String algName() {
        return "PasswordBasedMac";
    }

    public int getDigestLength() {
        return this.j.getDigestLength();
    }

    public byte[] getDigestBits() {
        return (byte[])this.a().clone();
    }

    byte[] a() {
        FIPS_140_2.assertReadyState();
        return this.k;
    }

    public boolean isValid() {
        return this.l;
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        PasswordBasedMAC passwordBasedMAC = new PasswordBasedMAC();
        passwordBasedMAC.k = (byte[])this.k.clone();
        passwordBasedMAC.l = this.l;
        passwordBasedMAC.b = (byte[])this.b.clone();
        passwordBasedMAC.c = new AlgorithmIdentifier(this.c.getOID(), this.c.getParameters());
        passwordBasedMAC.d = this.d;
        passwordBasedMAC.e = new AlgorithmIdentifier(this.e.getOID(), this.e.getParameters());
        passwordBasedMAC.f = this.f;
        passwordBasedMAC.g = (byte[])this.g.clone();
        passwordBasedMAC.h = (byte[])this.h.clone();
        passwordBasedMAC.i = (MessageDigest)this.i.clone();
        passwordBasedMAC.j = (MessageDigest)this.j.clone();
        return passwordBasedMAC;
    }

    protected MessageDigest.MDState b() {
        return null;
    }

    protected void a(MessageDigest.MDState mDState) {
        throw new RuntimeException("Method setState(MDState) not valid for PasswordBasedMAC class");
    }
}

