/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.Utils;

public class PBMacAlgID
extends AlgorithmIdentifier {
    private byte[] a;
    private AlgorithmIdentifier b;
    private BigInteger c;
    private AlgorithmIdentifier d;

    public PBMacAlgID() {
        super(AlgID.PasswordBasedMac.getOID());
    }

    public PBMacAlgID(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, BigInteger bigInteger, AlgorithmIdentifier algorithmIdentifier2) throws AlgorithmIdentifierException {
        this(PBMacAlgID.a(byArray, algorithmIdentifier, bigInteger, algorithmIdentifier2));
    }

    public PBMacAlgID(ASN1Object aSN1Object) throws AlgorithmIdentifierException {
        super(AlgID.PasswordBasedMac.getOID(), aSN1Object);
        this.a();
    }

    public PBMacAlgID(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public byte[] getSalt() {
        return this.a;
    }

    public AlgorithmIdentifier getOwfAlgID() {
        return this.b;
    }

    public BigInteger getCount() {
        return this.c;
    }

    public AlgorithmIdentifier getMacAlgID() {
        return this.d;
    }

    private static ASN1Object a(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, BigInteger bigInteger, AlgorithmIdentifier algorithmIdentifier2) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1OctetString(byArray));
        aSN1Sequence.addElement(algorithmIdentifier);
        aSN1Sequence.addElement(new ASN1Integer(bigInteger));
        aSN1Sequence.addElement(algorithmIdentifier2);
        return aSN1Sequence;
    }

    private void a() throws AlgorithmIdentifierException {
        ASN1Object aSN1Object = this.getParameters();
        if (aSN1Object != null && !(aSN1Object instanceof ASN1Null)) {
            try {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
                this.a = ((ASN1OctetString)aSN1Sequence.elementAt(0)).getValue();
                this.b = new AlgorithmIdentifier(Utils.toStream(aSN1Sequence.elementAt(1)));
                this.c = ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue();
                this.d = new AlgorithmIdentifier(Utils.toStream(aSN1Sequence.elementAt(3)));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new AlgorithmIdentifierException(classCastException.toString());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new AlgorithmIdentifierException(arrayIndexOutOfBoundsException.toString());
            }
        }
    }

    public Object clone() {
        PBMacAlgID pBMacAlgID;
        byte[] byArray = null;
        AlgorithmIdentifier algorithmIdentifier = null;
        AlgorithmIdentifier algorithmIdentifier2 = null;
        BigInteger bigInteger = null;
        if (this.a != null) {
            byArray = (byte[])this.a.clone();
        }
        if (this.b != null) {
            algorithmIdentifier = (AlgorithmIdentifier)this.b.clone();
        }
        if (this.d != null) {
            algorithmIdentifier2 = (AlgorithmIdentifier)this.d.clone();
        }
        if (this.c != null) {
            bigInteger = new BigInteger(this.c.toByteArray());
        }
        try {
            pBMacAlgID = new PBMacAlgID(byArray, algorithmIdentifier, this.c, algorithmIdentifier2);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidFormatException("Invalid algorotihm identifier.");
        }
        return pBMacAlgID;
    }

    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.a();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }
}

