/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class KeyPair
implements Externalizable {
    private PublicKey a;
    private PrivateKey b;

    public KeyPair() {
    }

    public KeyPair(PublicKey publicKey, PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        this.a = publicKey;
        this.b = privateKey;
    }

    public PublicKey getPublic() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public void setPublic(PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        this.a = publicKey;
    }

    public PrivateKey getPrivate() {
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public void setPrivate(PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        this.b = privateKey;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.a);
        aSN1Sequence.addElement(this.b);
        objectOutput.writeObject(Utils.toBytes(aSN1Sequence));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(byArray));
        this.a = CryptoUtils.inputSPKI(aSN1SequenceInputStream);
        this.b = CryptoUtils.inputPrivateKey(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

