/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.security.crypto.core.Coder;
import oracle.security.crypto.core.CoderException;
import oracle.security.crypto.fips.FIPS_140_2;

public class CoderOutputStream
extends FilterOutputStream {
    public static final int DECODE_MODE = 0;
    public static final int ENCODE_MODE = 1;
    protected int a = 1;
    protected Coder b;
    protected byte[] c;
    protected int d;

    public CoderOutputStream(OutputStream outputStream, Coder coder) {
        super(outputStream);
        this.b = coder;
        this.c = new byte[this.b.getBlockSize()];
        this.d = 0;
    }

    public Coder getCoder() {
        return this.b;
    }

    public int getMode() {
        return this.a;
    }

    public void setMode(int n) {
        this.a = n;
    }

    public synchronized void write(int n) throws IOException {
        FIPS_140_2.assertReadyState();
        this.c[this.d++] = (byte)n;
        try {
            if (this.d == this.b.getBlockSize()) {
                this.d = 0;
                if (this.a == 1) {
                    this.out.write(this.b.encodeOp(this.c));
                } else {
                    this.out.write(this.b.decodeOp(this.c));
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (CoderException coderException) {
            throw new IOException(coderException.toString());
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i2 = n; i2 < n3; ++i2) {
            this.write(byArray[i2]);
        }
    }

    public synchronized void flush() throws IOException {
        if (this.d != 0) {
            throw new IOException("Data length not multiple of block size");
        }
        this.out.flush();
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

