/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.compiler.BuildLog;
import oracle.ide.compiler.Compiler;
import oracle.ide.compiler.CopyListener;
import oracle.ide.compiler.CopyListener2;
import oracle.ide.compiler.Diagnostic;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ResourcePaths;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.compiler.BuildToolDefinition;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.Translator2;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compiler.NativeToAscii;
import oracle.ojc.interfaces.Storage;

public class CopyTranslator
implements Translator2 {
    private Translator.Log log = null;
    private String[] copyResSpec = null;
    private boolean reverseCopyRes = false;
    private Workspace workspace;
    private Project project;

    private CopyTranslator() {
    }

    @Override
    public String getName() {
        return "CopyTranslator";
    }

    @Override
    public ArrayList<String> getInputTypes() {
        if (this.copyResSpec != null && !this.reverseCopyRes) {
            ArrayList<String> v = new ArrayList<String>(this.copyResSpec.length);
            for (int i = 0; i < this.copyResSpec.length; ++i) {
                if (this.copyResSpec[i].startsWith(".")) {
                    v.add(this.copyResSpec[i]);
                    continue;
                }
                v.add("." + this.copyResSpec[i]);
            }
            return v;
        }
        return new ArrayList<String>(0);
    }

    @Override
    public ArrayList<String> getOutputTypes() {
        return new ArrayList<String>(0);
    }

    @Override
    public boolean canBuild(Storage store) {
        return JCompiler.isCopyable(this.project, store.getName(), this.copyResSpec, this.reverseCopyRes);
    }

    @Override
    public boolean needToBuild(Storage store) {
        return false;
    }

    @Override
    public void setLog(Translator.Log log) {
        this.log = log;
    }

    @Override
    public void setParameter(String name, String value) {
        throw new Error();
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            this.copyResSpec = JCompiler.getCopyRes(project);
            this.reverseCopyRes = JCompiler.getReverseCopyRes(project);
        }
    }

    @Override
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void updateProject(Project project) {
        this.setProject(project);
    }

    private boolean native2ascii(Storage f, URL srcUrl, URL destUrl) {
        String in = new File(srcUrl.getPath()).getPath();
        File outFile = new File(destUrl.getPath());
        String out = outFile.getPath();
        Throwable excpt = null;
        try {
            URL destDir = URLFileSystem.getParent((URL)destUrl);
            if (destDir != null) {
                URLFileSystem.mkdirs((URL)destDir);
            }
            if (NativeToAscii.convert(IdeUtil.getIdeEncoding(), in, out)) {
                URLFileSystem.setLastModified((URL)destUrl, (long)(URLFileSystem.lastModified((URL)destUrl) + 1L));
                return true;
            }
        }
        catch (Throwable e) {
            excpt = e;
        }
        String excptStr = excpt != null ? excpt.getMessage() : "";
        String msg = CompArb.format(69, f.getName(), excptStr);
        this.log.error(f, 0, 0, 0, msg);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCopy(Storage f, URL url, String srcName, Node node, URL outname) throws IOException {
        if (UnifiedBuildSystem.logger.isEnabled()) {
            UnifiedBuildSystem.logger.trace("CopyTranslator handled copy of {0}", new Object[]{url.getPath()});
        }
        UnifiedBuildSystem.getInstance().markTranslated(this, f);
        boolean n2a = srcName.endsWith(".properties");
        if (UnifiedBuildSystem.showCompileProgress) {
            int msgId = n2a ? 68 : 65;
            Compiler.getCompiler().logOutMsg("  ");
            Compiler.getCompiler().logOutMsg(CompArb.format(msgId, f.getPath()));
            Compiler.getCompiler().logOutMsg("\n");
        }
        URL n2aOutname = null;
        URL tmpURL = null;
        try {
            if (n2a) {
                URL outParent = URLFileSystem.getParent((URL)outname);
                if (outParent != null) {
                    URLFileSystem.mkdirs((URL)outParent);
                }
                tmpURL = URLFileSystem.createTempFile((String)"JDev", (String)".properties", (URL)outParent);
                n2aOutname = outname;
                outname = tmpURL;
            }
            if (node != null) {
                try (InputStream is = null;){
                    is = node instanceof TextNode ? ((TextNode)node).getInputStream(false) : node.getInputStream();
                    URLFileSystem.copy((InputStream)is, (URL)outname);
                }
            } else {
                URLFileSystem.copy((URL)url, (URL)outname);
            }
            if (n2a && !this.native2ascii(f, outname, n2aOutname)) {
                URLFileSystem.copy((URL)outname, (URL)n2aOutname);
            }
        }
        finally {
            File tmpFile;
            if (tmpURL != null && !URLFileSystem.delete((URL)tmpURL) && (tmpFile = new File(tmpURL.getPath())).exists()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int translate(Project prj, boolean rebuild, ArrayList<Storage> sources, ArrayList<Storage> results) {
        UnifiedBuildSystem.getInstance().beginMarking(this);
        Project jprj = prj;
        URL outpath = JavaProject.getInstance((Project)jprj).getOutputDirectory();
        String outpathFilePath = outpath != null ? new File(outpath.getPath()).getPath() : null;
        URLPath htmlpath = new URLPath(J2eeSettings.getInstance((Project)jprj).getHtmlRootDirectory());
        JCompiler jcompiler = JCompiler.getInstance();
        jcompiler.getNewCopyListeners(null, jprj);
        ArrayList<CopyListener> copyListeners = new ArrayList<CopyListener>();
        for (BuildToolDefinition<CopyListener> def : jcompiler.getCopyListeners()) {
            CopyListener listener;
            if (!def.conditionsSatisfied(null, jprj) || (listener = (CopyListener)def.retrieveBuildTool()) == null) continue;
            copyListeners.add(listener);
        }
        if (UnifiedBuildSystem.logger.isEnabled()) {
            UnifiedBuildSystem.logger.trace("CopyListeners for project: {0}", new Object[]{prj.getLongLabel()});
            for (int i = 0; i < copyListeners.size(); ++i) {
                UnifiedBuildSystem.logger.trace(((CopyListener)copyListeners.get(i)).getClass().getName());
            }
        }
        int errcnt = 0;
        CopyBuildLog copyBuildLog = new CopyBuildLog();
        copyBuildLog.allowLogging = true;
        try {
            this.initializeCopyListeners(copyListeners, jprj, copyBuildLog);
            URLPath sourceUrlPath = PathsConfiguration.getInstance((Project)jprj).getSourcePath();
            URLPath resourceUrlPath = ResourcePaths.getInstance((PropertyStorage)jprj).getProjectResourcesPath();
            for (int i = 0; i < sources.size() && !Thread.currentThread().isInterrupted(); ++i) {
                Storage f = sources.get(i);
                try {
                    long srcTime;
                    URL[] alternateUrl;
                    URL url;
                    copyBuildLog.currentStorage = f;
                    Node node = f instanceof IdeStorage ? ((IdeStorage)f).node : null;
                    URL uRL = url = node != null ? node.getURL() : URLFactory.newFileURL((String)f.getPath());
                    if (outpathFilePath != null && new File(url.getPath()).getPath().startsWith(outpathFilePath) || this.callCopyListeners(copyListeners, url, f, alternateUrl = new URL[]{null})) continue;
                    URL outname = alternateUrl[0];
                    String srcName = null;
                    if (sourceUrlPath != null) {
                        srcName = sourceUrlPath.toRelativePath(url);
                    }
                    if (outname == null && srcName == null && htmlpath.toRelativePath(url) != null) continue;
                    if (srcName == null && resourceUrlPath != null) {
                        Object object = resourceUrlPath.iteratorLock();
                        synchronized (object) {
                            for (URL resourcePath : resourceUrlPath) {
                                String relativePath = URLFileSystem.toRelativeSpec((URL)url, (URL)resourcePath, (boolean)true);
                                if (srcName != null && (relativePath == null || relativePath.length() <= srcName.length())) continue;
                                srcName = relativePath;
                            }
                        }
                    }
                    if (outname == null) {
                        if (srcName == null) {
                            if (!UnifiedBuildSystem.showCompileProgress) continue;
                            Compiler.getCompiler().logOutMsg("  ");
                            Compiler.getCompiler().logOutMsg(CompArb.format(66, f.getPath()));
                            Compiler.getCompiler().logOutMsg("\n");
                            continue;
                        }
                        outname = URLFactory.newURL((URL)outpath, (String)srcName);
                    } else if (srcName == null) {
                        srcName = url.getPath();
                    }
                    if (node == null && !URLFileSystem.exists((URL)url)) {
                        int idx = 59;
                        String str = CompArb.format(59, f.getPath());
                        this.log.error(f, 0, 0, 0, str);
                        ++errcnt;
                        continue;
                    }
                    if (outpath == null) {
                        this.log.error(f, 0, 0, 0, CompArb.getString(61));
                        ++errcnt;
                        continue;
                    }
                    long l = srcTime = node != null ? node.getTimestamp() : URLFileSystem.lastModified((URL)url);
                    if (!rebuild && srcTime <= URLFileSystem.lastModified((URL)outname) || node != null && node.getURL().equals(outname) || node == null && url.equals(outname)) continue;
                    if (!URLFileSystem.isReadOnly((URL)outname)) {
                        this.performCopy(f, url, srcName, node, outname);
                        if (outname == null) continue;
                        results.add(Helpers.createFileStorage(outname.getPath()));
                        continue;
                    }
                    this.log.error(f, 0, 0, 0, CompArb.getString(57));
                    ++errcnt;
                    continue;
                }
                catch (IOException e) {
                    int index = e instanceof FileNotFoundException ? 59 : 118;
                    String errorString = CompArb.format(index, f.getPath());
                    this.log.error(f, 0, 0, 0, errorString);
                    ++errcnt;
                    continue;
                }
                catch (Exception e) {
                    FeedbackManager.reportException((String)"Exception in CopyTranslator while copying file", (Throwable)e);
                    this.log.error(f, 0, 0, 0, CompArb.getString(89));
                    ++errcnt;
                }
            }
            this.terminateCopyListeners(copyListeners);
        }
        finally {
            copyBuildLog.allowLogging = false;
            copyBuildLog.currentStorage = null;
            copyBuildLog = null;
        }
        return errcnt;
    }

    private void initializeCopyListeners(Collection<CopyListener> listeners, Project project, CopyBuildLog copyBuildLog) {
        for (CopyListener listener : listeners) {
            long startTime = System.currentTimeMillis();
            listener.initialize(project);
            if (listener instanceof CopyListener2) {
                CopyListener2 copyListener2 = (CopyListener2)listener;
                copyListener2.setWorkspace(this.workspace);
                copyListener2.setBuildLog((BuildLog)copyBuildLog);
            }
            long totalTime = System.currentTimeMillis() - startTime;
            String name = listener.getClass().getName();
            UnifiedBuildSystem.logger.trace("CopyListener.initialize for " + name + ": " + totalTime);
            UnifiedBuildSystem.getInstance().addCopyListenerTime(name, totalTime);
        }
    }

    private boolean callCopyListeners(Collection<CopyListener> listeners, URL url, Storage source, URL[] alternateUrl) {
        for (CopyListener listener : listeners) {
            long startTime = System.currentTimeMillis();
            boolean handled = listener.handleCopy(url, alternateUrl);
            long totalTime = System.currentTimeMillis() - startTime;
            String name = listener.getClass().getName();
            UnifiedBuildSystem.logger.trace("CopyListener.handleCopy for " + name + ": " + totalTime);
            UnifiedBuildSystem.getInstance().addCopyListenerTime(name, totalTime);
            if (!handled) continue;
            boolean copied = false;
            if (handled) {
                copied = true;
                if (listener instanceof CopyListener2) {
                    copied = ((CopyListener2)listener).markFileAsCopied(url);
                }
                if (copied) {
                    UnifiedBuildSystem.getInstance().markTranslated(this, source);
                }
            }
            if (UnifiedBuildSystem.logger.isEnabled()) {
                String msg = copied ? "copied" : (alternateUrl[0] != null ? "adjusted output of" : "handled");
                UnifiedBuildSystem.logger.trace("CopyListener {0} {1} {2}", new Object[]{listener.getClass().getName(), msg, url.getPath()});
            }
            return handled;
        }
        return false;
    }

    private void terminateCopyListeners(Collection<CopyListener> listeners) {
        for (CopyListener listener : listeners) {
            listener.terminate();
        }
    }

    private class CopyBuildLog
    implements BuildLog {
        boolean allowLogging = true;
        Storage currentStorage;

        private CopyBuildLog() {
        }

        public void diagnostic(Diagnostic diagnostic) {
            IdeLog ideLog;
            if (this.allowLogging && (ideLog = UnifiedBuildSystem.ideLog) != null) {
                if (diagnostic.getStorage() == null) {
                    diagnostic.setStorage(this.currentStorage);
                }
                ideLog.diagnostic(diagnostic);
            }
        }
    }
}

