/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.AdminStatus;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.arb.ArbNodeStatus;
import oracle.kv.impl.arb.admin.ArbNodeAdminAPI;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.ArbNode;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.Ping;

public class PingCollector {
    private static final int MAX_N_THREADS = 10;
    private Map<StorageNode, StorageNodeStatus> snMap;
    private Map<RepNode, RepNodeStatus> rnMap;
    private Map<ArbNode, ArbNodeStatus> anMap;
    private Map<AdminId, AdminInfo> adminMap;
    private Map<ResourceId, ServiceChange> monitoredChanges;
    private final List<Ping.Problem> problems = Collections.synchronizedList(new ArrayList());
    private final Topology topo;
    private final Parameters params;
    private final LoginManager adminLoginManager;

    PingCollector(Topology topo, Parameters params, LoginManager adminLoginManager) {
        this.topo = topo;
        this.params = params;
        this.adminLoginManager = adminLoginManager;
    }

    public PingCollector(Topology topo) {
        this(topo, null, null);
    }

    Map<StorageNode, StorageNodeStatus> getSNMap() {
        if (this.snMap == null) {
            this.snMap = Collections.synchronizedMap(new HashMap());
            this.forEachStorageNode(new StorageNodeCallback(){

                @Override
                public void nodeCallback(StorageNode sn, StorageNodeStatus status) {
                    PingCollector.this.snMap.put(sn, status);
                }
            });
        }
        return this.snMap;
    }

    Map<RepNode, RepNodeStatus> getRNMap() {
        if (this.rnMap == null) {
            this.rnMap = Collections.synchronizedMap(new TreeMap());
            this.forEachRepNode(new RepNodeCallback(){

                @Override
                public void nodeCallback(RepNode rn, RepNodeStatus status) {
                    PingCollector.this.rnMap.put(rn, status);
                }
            });
        }
        return this.rnMap;
    }

    Map<AdminId, AdminInfo> getAdminMap() {
        if (this.adminMap == null) {
            this.adminMap = Collections.synchronizedMap(new HashMap());
            this.monitoredChanges = Collections.synchronizedMap(new HashMap());
            this.forEachAdmin(new AdminCallback(){

                @Override
                public void nodeCallback(AdminId aId, AdminInfo info) {
                    PingCollector.this.adminMap.put(aId, info);
                }
            });
        }
        return this.adminMap;
    }

    Map<ArbNode, ArbNodeStatus> getANMap() {
        if (this.anMap == null) {
            this.anMap = new TreeMap<ArbNode, ArbNodeStatus>();
            this.forEachArbNode(new ArbNodeCallback(){

                @Override
                public void nodeCallback(ArbNode an, ArbNodeStatus status) {
                    PingCollector.this.anMap.put(an, status);
                }
            });
        }
        return this.anMap;
    }

    Map<ResourceId, ServiceChange> getMonitoredChanges() {
        if (this.monitoredChanges == null) {
            this.getAdminMap();
        }
        return this.monitoredChanges;
    }

    List<Ping.Problem> getProblems() {
        return this.problems;
    }

    public Map<ResourceId, ConfigurableService.ServiceStatus> getTopologyStatus() {
        ConfigurableService.ServiceStatus status;
        HashMap<ResourceId, ConfigurableService.ServiceStatus> ret = new HashMap<ResourceId, ConfigurableService.ServiceStatus>();
        for (Map.Entry<StorageNode, StorageNodeStatus> entry : this.getSNMap().entrySet()) {
            status = entry.getValue() == null ? ConfigurableService.ServiceStatus.UNREACHABLE : entry.getValue().getServiceStatus();
            ret.put((ResourceId)entry.getKey().getResourceId(), status);
        }
        for (Map.Entry<Topology.Component, Object> entry : this.getRNMap().entrySet()) {
            status = entry.getValue() == null ? ConfigurableService.ServiceStatus.UNREACHABLE : ((RepNodeStatus)entry.getValue()).getServiceStatus();
            ret.put((ResourceId)((RepNode)entry.getKey()).getResourceId(), status);
        }
        for (Map.Entry<Comparable<StorageNode>, Object> entry : this.getAdminMap().entrySet()) {
            AdminStatus aStatus;
            status = null;
            status = entry.getValue() == null ? ConfigurableService.ServiceStatus.UNREACHABLE : ((aStatus = ((AdminInfo)entry.getValue()).adminStatus) == null ? ConfigurableService.ServiceStatus.UNREACHABLE : aStatus.getServiceStatus());
            ret.put((ResourceId)((Object)entry.getKey()), status);
        }
        return ret;
    }

    public RepNode getMaster(RepGroupId rgId) {
        final List master = Collections.synchronizedList(new ArrayList());
        this.forEachRepNodeInShard(rgId, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                if (status != null && status.getReplicationState().isMaster()) {
                    master.add(rn);
                }
            }
        });
        return master.size() == 1 ? (RepNode)master.get(0) : null;
    }

    public RNNameHAPort getMasterNamePort(RepGroupId rgId) {
        final List namePort = Collections.synchronizedList(new ArrayList());
        this.forEachRepNodeInShard(rgId, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                if (status != null && status.getReplicationState().isMaster()) {
                    String rnName = ((RepNodeId)rn.getResourceId()).getFullName();
                    namePort.add(new RNNameHAPort(rnName, status.getHAHostPort()));
                }
            }
        });
        return namePort.size() == 1 ? (RNNameHAPort)namePort.get(0) : null;
    }

    public Map<RepNodeId, RepNodeStatus> getRepNodeStatus(RepGroupId rgId) {
        final Map<RepNodeId, RepNodeStatus> statusMap = Collections.synchronizedMap(new HashMap());
        this.forEachRepNodeInShard(rgId, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                statusMap.put(rn.getResourceId(), status);
            }
        });
        return statusMap;
    }

    public Map<ArbNodeId, ArbNodeStatus> getArbNodeStatus(RepGroupId rgId) {
        final HashMap<ArbNodeId, ArbNodeStatus> statusMap = new HashMap<ArbNodeId, ArbNodeStatus>();
        this.forEachArbNodeInShard(rgId, new ArbNodeCallback(){

            @Override
            public void nodeCallback(ArbNode an, ArbNodeStatus status) {
                statusMap.put(an.getResourceId(), status);
            }
        });
        return statusMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachStorageNode(final StorageNodeCallback callback) {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<9> tasks = new ArrayList<9>();
        final RegistryUtils regUtils = new RegistryUtils(this.topo, null);
        for (final StorageNode sn : this.topo.getStorageNodeMap().getAll()) {
            tasks.add(new Callable<Void>(){

                /*
                 * Loose catch block
                 */
                @Override
                public Void call() throws Exception {
                    StorageNodeStatus status = null;
                    try {
                        StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent((StorageNodeId)sn.getResourceId());
                        status = sna.ping();
                        callback.nodeCallback(sn, status);
                    }
                    catch (RemoteException re) {
                        PingCollector.this.problems.add(new Ping.Problem((ResourceId)sn.getResourceId(), sn.getHostname(), sn.getRegistryPort(), "Can't call ping for SN: ", re));
                        callback.nodeCallback(sn, status);
                    }
                    catch (NotBoundException e) {
                        PingCollector.this.problems.add(new Ping.Problem((ResourceId)sn.getResourceId(), sn.getHostname(), sn.getRegistryPort(), "No RMI service for SN", e));
                        callback.nodeCallback(sn, status);
                        {
                            catch (Throwable throwable) {
                                callback.nodeCallback(sn, status);
                                throw throwable;
                            }
                        }
                    }
                    return null;
                }
            });
        }
        try {
            executor.invokeAll(tasks);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executor.shutdown();
        }
    }

    private void forEachRepNode(RepNodeCallback callback) {
        for (RepGroup rg : this.topo.getRepGroupMap().getAll()) {
            this.forEachRepNodeInShard((RepGroupId)rg.getResourceId(), callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachRepNodeInShard(RepGroupId rgId, final RepNodeCallback callback) {
        RepGroup group = this.topo.get(rgId);
        if (group == null) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<10> tasks = new ArrayList<10>();
        final RegistryUtils regUtils = new RegistryUtils(this.topo, null);
        for (final RepNode rn : group.getRepNodes()) {
            tasks.add(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public Void call() throws Exception {
                    RepNodeStatus status = null;
                    StorageNode sn = PingCollector.this.topo.get(rn.getStorageNodeId());
                    try {
                        RepNodeAdminAPI rna = regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                        status = rna.ping();
                        callback.nodeCallback(rn, status);
                    }
                    catch (RemoteException re) {
                        PingCollector.this.problems.add(new Ping.Problem((ResourceId)rn.getResourceId(), sn.getHostname(), sn.getRegistryPort(), "Can't call ping for RN:" + re));
                        callback.nodeCallback(rn, status);
                    }
                    catch (NotBoundException e) {
                        PingCollector.this.problems.add(new Ping.Problem((ResourceId)rn.getResourceId(), sn.getHostname(), sn.getRegistryPort(), "No RMI service for RN: " + e));
                        callback.nodeCallback(rn, status);
                        {
                            catch (Throwable throwable) {
                                callback.nodeCallback(rn, status);
                                throw throwable;
                            }
                        }
                    }
                    return null;
                }
            });
        }
        try {
            executor.invokeAll(tasks);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachAdmin(final AdminCallback callback) {
        if (this.params == null) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<11> tasks = new ArrayList<11>();
        for (final AdminId aId : this.params.getAdminIds()) {
            tasks.add(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    StorageNodeId snId = PingCollector.this.params.get(aId).getStorageNodeId();
                    StorageNodeParams snp = PingCollector.this.params.get(snId);
                    String hostname = snp.getHostname();
                    int port = snp.getRegistryPort();
                    AdminInfo info = new AdminInfo(snId);
                    try {
                        CommandServiceAPI admin = RegistryUtils.getAdmin(hostname, port, PingCollector.this.adminLoginManager);
                        info.adminStatus = admin.getAdminStatus();
                        if (info.adminStatus.getIsAuthoritativeMaster()) {
                            Map monitorMap = admin.getStatusMap();
                            PingCollector.this.monitoredChanges.putAll(monitorMap);
                        }
                    }
                    catch (AdminFaultException afe) {
                        PingCollector.this.problems.add(new Ping.Problem(aId, hostname, port, "Can't get status for Admin:", afe));
                    }
                    catch (RemoteException re) {
                        PingCollector.this.problems.add(new Ping.Problem(aId, hostname, port, "Can't get status for Admin:", re));
                    }
                    catch (NotBoundException e) {
                        PingCollector.this.problems.add(new Ping.Problem(aId, hostname, port, "No RMI Service for Admin:", e));
                    }
                    finally {
                        callback.nodeCallback(aId, info);
                    }
                    return null;
                }
            });
        }
        try {
            executor.invokeAll(tasks);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executor.shutdown();
        }
    }

    private void forEachArbNodeInShard(RepGroupId rgId, ArbNodeCallback callback) {
        RepGroup group = this.topo.get(rgId);
        if (group == null) {
            return;
        }
        RegistryUtils regUtils = new RegistryUtils(this.topo, null);
        for (ArbNode an : group.getArbNodes()) {
            ArbNodeStatus status = null;
            StorageNode sn = this.topo.get(an.getStorageNodeId());
            try {
                ArbNodeAdminAPI ana = regUtils.getArbNodeAdmin((ArbNodeId)an.getResourceId());
                status = ana.ping();
            }
            catch (RemoteException re) {
                this.problems.add(new Ping.Problem((ResourceId)an.getResourceId(), sn.getHostname(), sn.getRegistryPort(), "Can't call ping for AN:" + re));
            }
            catch (NotBoundException e) {
                this.problems.add(new Ping.Problem((ResourceId)an.getResourceId(), sn.getHostname(), sn.getRegistryPort(), "No RMI service for AN: " + e));
            }
            callback.nodeCallback(an, status);
        }
    }

    private void forEachArbNode(ArbNodeCallback callback) {
        for (RepGroup rg : this.topo.getRepGroupMap().getAll()) {
            this.forEachArbNodeInShard((RepGroupId)rg.getResourceId(), callback);
        }
    }

    public class RNNameHAPort {
        private final String fullName;
        private final String haHostPort;

        RNNameHAPort(String fullName, String haHostPort) {
            this.fullName = fullName;
            this.haHostPort = haHostPort;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getHAHostPort() {
            return this.haHostPort;
        }
    }

    class AdminInfo {
        final StorageNodeId snId;
        AdminStatus adminStatus;

        AdminInfo(StorageNodeId snId) {
            this.snId = snId;
        }
    }

    private static interface ArbNodeCallback {
        public void nodeCallback(ArbNode var1, ArbNodeStatus var2);
    }

    private static interface AdminCallback {
        public void nodeCallback(AdminId var1, AdminInfo var2);
    }

    private static interface RepNodeCallback {
        public void nodeCallback(RepNode var1, RepNodeStatus var2);
    }

    private static interface StorageNodeCallback {
        public void nodeCallback(StorageNode var1, StorageNodeStatus var2);
    }
}

