/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@Persistent
public final class TimeToLive
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long value;
    private final TimeUnit unit;
    public static final TimeToLive DO_NOT_EXPIRE = TimeToLive.ofDays(0L);

    public static TimeToLive ofHours(long hours) {
        if (hours < 0L) {
            throw new IllegalArgumentException("TimeToLive does not support negative time periods");
        }
        return new TimeToLive(hours, TimeUnit.HOURS);
    }

    public static TimeToLive ofDays(long days) {
        if (days < 0L) {
            throw new IllegalArgumentException("TimeToLive does not support negative time periods");
        }
        return new TimeToLive(days, TimeUnit.DAYS);
    }

    public long toDays() {
        return TimeUnit.DAYS.convert(this.value, this.unit);
    }

    public long toHours() {
        return TimeUnit.HOURS.convert(this.value, this.unit);
    }

    public long toExpirationTime(long referenceTime) {
        if (this.value == 0L) {
            return 0L;
        }
        return referenceTime + this.toMillis();
    }

    public static TimeToLive fromExpirationTime(long expirationTime, long referenceTime) {
        long MILLIS_PER_HOUR = 3600000L;
        if (expirationTime == 0L) {
            return DO_NOT_EXPIRE;
        }
        long hours = (expirationTime + 3600000L - 1L) / 3600000L;
        boolean timeInHours = hours % 24L != 0L;
        long duration = expirationTime - referenceTime;
        if (duration == 0L) {
            duration = -3600000L;
            timeInHours = true;
        }
        if (timeInHours) {
            return new TimeToLive(TimeUnit.HOURS.convert(duration, TimeUnit.MILLISECONDS), TimeUnit.HOURS);
        }
        return new TimeToLive(TimeUnit.DAYS.convert(duration, TimeUnit.MILLISECONDS), TimeUnit.DAYS);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TimeToLive)) {
            return false;
        }
        TimeToLive otherTTL = (TimeToLive)other;
        if (this.value == 0L && otherTTL.value == 0L) {
            return true;
        }
        return this.unit == otherTTL.unit && this.value == otherTTL.value;
    }

    public int hashCode() {
        return (int)(this.value >>> 32 ^ this.value) + this.unit.hashCode();
    }

    public String toString() {
        return this.value + " " + this.unit.toString();
    }

    public static TimeToLive createTimeToLive(long value, TimeUnit unit) {
        return new TimeToLive(value, unit);
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    private TimeToLive(long value, TimeUnit unit) {
        if (unit != TimeUnit.DAYS && unit != TimeUnit.HOURS) {
            throw new IllegalArgumentException("Invalid TimeUnit (" + (Object)((Object)unit) + ") in TimeToLive construction." + "Must be DAYS or HOURS.");
        }
        this.value = value;
        this.unit = unit;
    }

    private TimeToLive() {
        this(0L, TimeUnit.DAYS);
    }

    private long toMillis() {
        return TimeUnit.MILLISECONDS.convert(this.value, this.unit);
    }
}

