/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.LongValue;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.NumberValue;
import oracle.kv.table.StringValue;
import oracle.kv.table.TimestampValue;

public class FieldRange
implements FastExternalizable,
Cloneable {
    private final String fieldPath;
    private final FieldDef fieldDef;
    private FieldValue start;
    private boolean startInclusive;
    private FieldValue end;
    private boolean endInclusive;
    private final int storageSize;

    public FieldRange(String fieldPath, FieldDef fieldDef, int storageSize) {
        this.fieldPath = fieldPath;
        this.fieldDef = fieldDef;
        this.storageSize = storageSize;
        assert (fieldDef.isAtomic());
    }

    public FieldRange(DataInput in, short serialVersion) throws IOException {
        this.fieldPath = in.readUTF();
        this.startInclusive = in.readBoolean();
        this.endInclusive = in.readBoolean();
        this.fieldDef = FieldDefSerialization.readFieldDef(in, serialVersion);
        this.start = FieldValueSerialization.readFieldValue(this.fieldDef, in, serialVersion);
        this.end = FieldValueSerialization.readFieldValue(this.fieldDef, in, serialVersion);
        this.storageSize = 0;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeUTF(this.fieldPath);
        out.writeBoolean(this.startInclusive);
        out.writeBoolean(this.endInclusive);
        FieldDefSerialization.writeFieldDef(this.fieldDef, out, serialVersion);
        FieldValueSerialization.writeFieldValue(this.start, false, out, serialVersion);
        FieldValueSerialization.writeFieldValue(this.end, false, out, serialVersion);
    }

    public FieldRange clone() {
        try {
            return (FieldRange)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public MultiRowOptions createMultiRowOptions() {
        return new MultiRowOptions(this);
    }

    public FieldDef getField() {
        return this.fieldDef;
    }

    public FieldValue getStart() {
        return this.start;
    }

    public boolean getStartInclusive() {
        return this.startInclusive;
    }

    public FieldValue getEnd() {
        return this.end;
    }

    public boolean getEndInclusive() {
        return this.endInclusive;
    }

    public FieldDef getDefinition() {
        return this.fieldDef;
    }

    public String getFieldName() {
        return this.fieldPath;
    }

    public FieldRange setStart(int value, boolean isInclusive) {
        IntegerValue val = this.fieldDef.createInteger(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(double value, boolean isInclusive) {
        DoubleValue val = this.fieldDef.createDouble(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(float value, boolean isInclusive) {
        FloatValue val = this.fieldDef.createFloat(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(long value, boolean isInclusive) {
        LongValue val = this.fieldDef.createLong(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(String value, boolean isInclusive) {
        StringValue val = this.fieldDef.createString(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStartEnum(String value, boolean isInclusive) {
        EnumValue val = this.fieldDef.createEnum(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(Timestamp value, boolean isInclusive) {
        TimestampValue val = this.fieldDef.createTimestamp(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(BigDecimal value, boolean isInclusive) {
        NumberValue val = this.fieldDef.createNumber(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setEnd(int value, boolean isInclusive) {
        IntegerValue val = this.fieldDef.createInteger(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(double value, boolean isInclusive) {
        DoubleValue val = this.fieldDef.createDouble(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(float value, boolean isInclusive) {
        FloatValue val = this.fieldDef.createFloat(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(long value, boolean isInclusive) {
        LongValue val = this.fieldDef.createLong(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(String value, boolean isInclusive) {
        StringValue val = this.fieldDef.createString(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEndEnum(String value, boolean isInclusive) {
        EnumValue val = this.fieldDef.createEnum(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(Timestamp value, boolean isInclusive) {
        TimestampValue val = this.fieldDef.createTimestamp(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(BigDecimal value, boolean isInclusive) {
        NumberValue val = this.fieldDef.createNumber(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setStart(FieldValue value, boolean isInclusive) {
        return this.setStart(value, isInclusive, true);
    }

    public FieldRange setEnd(FieldValue value, boolean isInclusive) {
        return this.setEnd(value, isInclusive, true);
    }

    public FieldRange setStart(FieldValue value, boolean isInclusive, boolean validate) {
        if (value != null && !this.fieldDef.isType(value.getType())) {
            throw new IllegalArgumentException("Value is not of correct type: " + value.getType());
        }
        return this.setStartValue(value, isInclusive, validate);
    }

    public FieldRange setEnd(FieldValue value, boolean isInclusive, boolean validate) {
        if (value != null && !this.fieldDef.isType(value.getType())) {
            throw new IllegalArgumentException("Value is not of correct type: " + value.getType());
        }
        return this.setEndValue(value, isInclusive, validate);
    }

    public FieldRange setStartValue(FieldValue value, boolean isInclusive) {
        return this.setStartValue(value, isInclusive, true);
    }

    private FieldRange setStartValue(FieldValue value, boolean isInclusive, boolean validate) {
        this.start = value;
        this.startInclusive = isInclusive;
        if (validate) {
            this.validate();
        }
        return this;
    }

    private FieldRange setEndValue(FieldValue value, boolean isInclusive) {
        return this.setEndValue(value, isInclusive, true);
    }

    private FieldRange setEndValue(FieldValue value, boolean isInclusive, boolean validate) {
        this.end = value;
        this.endInclusive = isInclusive;
        if (validate) {
            this.validate();
        }
        return this;
    }

    public int getStorageSize() {
        return this.storageSize;
    }

    public boolean check() {
        if (this.start != null && this.end != null) {
            int cmp = this.start.compareTo(this.end);
            if (cmp > 0) {
                return false;
            }
            if (!(cmp != 0 || this.endInclusive && this.startInclusive)) {
                return false;
            }
        }
        return true;
    }

    private void validate() {
        if (!this.check()) {
            throw new IllegalArgumentException("FieldRange: start value must be less than the end value");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(" \"Name\" : ").append(this.fieldPath);
        sb.append(", \"Type\" : ").append(this.fieldDef.getType());
        sb.append(", \"Start\" : ").append(this.start != null ? this.start : "null");
        sb.append(", \"End\" : ").append(this.end != null ? this.end : "null");
        sb.append(", \"StartInclusive\" : ").append(this.startInclusive);
        sb.append(", \"EndInclusive\" : ").append(this.endInclusive);
        sb.append(" }");
        return sb.toString();
    }
}

