/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.TimeoutSocket;

public class SSLClientSocketFactory
extends ClientSocketFactory {
    private static final long serialVersionUID = 1L;
    private final String kvStoreName;
    private final Use clientUse;
    private static SSLControl trustedSSLControl;
    private static SSLControl defaultUserSSLControl;
    private static final Map<String, SSLControl> userSSLControlMap;

    public SSLClientSocketFactory(String name, int connectTimeoutMs, int readTimeoutMs, String kvStoreName) {
        super(name, connectTimeoutMs, readTimeoutMs);
        this.kvStoreName = kvStoreName;
        this.clientUse = Use.USER;
    }

    public SSLClientSocketFactory(String name, int connectTimeoutMs, int readTimeoutMs) {
        this(name, connectTimeoutMs, readTimeoutMs, Use.USER);
    }

    public SSLClientSocketFactory(String name, int connectTimeoutMs, int readTimeoutMs, Use clientUse) {
        super(name, connectTimeoutMs, readTimeoutMs);
        this.kvStoreName = null;
        this.clientUse = clientUse;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kvStoreName == null ? 0 : this.kvStoreName.hashCode()) + (this.clientUse == null ? 0 : this.clientUse.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "<SSLClientSocketFactory name=" + this.name + " id=" + this.hashCode() + " connectMs=" + this.connectTimeoutMs + " readMs=" + this.readTimeoutMs + " kvStoreName=" + this.kvStoreName + " clientUse=" + (Object)((Object)this.clientUse) + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSLClientSocketFactory)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SSLClientSocketFactory other = (SSLClientSocketFactory)obj;
        if (this.clientUse == null ? other.clientUse != null : !this.clientUse.equals((Object)other.clientUse)) {
            return false;
        }
        return !(this.kvStoreName == null ? other.kvStoreName != null : !this.kvStoreName.equals(other.kvStoreName));
    }

    @Override
    public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        TimeoutSocket sock = this.createTimeoutSocket(host, port);
        try {
            SSLContext context = null;
            SSLControl control = null;
            if (Use.TRUSTED.equals((Object)this.clientUse)) {
                if (trustedSSLControl == null) {
                    ((Socket)sock).close();
                    throw new IOException("Cannot create TRUSTED client SSLSocket with empty trustedSSLControl");
                }
                control = trustedSSLControl;
                context = control.sslContext();
            } else {
                if (this.kvStoreName != null) {
                    control = userSSLControlMap.get(this.kvStoreName);
                }
                if (control == null && defaultUserSSLControl != null) {
                    control = defaultUserSSLControl;
                }
                context = control == null ? SSLContext.getDefault() : control.sslContext();
            }
            SSLSocket sslSock = (SSLSocket)context.getSocketFactory().createSocket(sock, host, port, true);
            if (control != null) {
                control.applySSLParameters(sslSock);
            }
            sslSock.startHandshake();
            if (control != null && control.hostVerifier() != null && !control.hostVerifier().verify(host, sslSock.getSession())) {
                throw new IOException("SSL connection to host " + host + " is not valid.");
            }
            return sslSock;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException("Unknown algorithm", nsae);
        }
    }

    public static void clearUserSSLControlMap() {
        userSSLControlMap.clear();
    }

    static void setTrustedControl(SSLControl trustedControl) {
        trustedSSLControl = trustedControl;
    }

    static void setUserControl(SSLControl userControl, String storeContext) {
        if (storeContext != null) {
            userSSLControlMap.put(storeContext, userControl);
        }
        defaultUserSSLControl = userControl;
    }

    static {
        userSSLControlMap = new ConcurrentHashMap<String, SSLControl>();
    }

    public static enum Use {
        USER,
        TRUSTED;

    }
}

