/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import com.sleepycat.util.PackedInteger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializationUtil {
    public static final String EMPTY_STRING = new String();

    public static <T> T getObject(byte[] bytes, Class<T> oclass) {
        if (bytes == null) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception deserializing object: " + oclass.getName(), ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Exception deserializing object: " + oclass.getName(), cnfe);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Exception closing deserializing stream", ioe);
                }
            }
        }
    }

    public static byte[] getBytes(Object object) {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception serializing object: " + object.getClass().getName(), ioe);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Exception closing serializing stream", ioe);
                }
            }
        }
    }

    public static int readPackedInt(DataInput in) throws IOException {
        byte[] bytes = new byte[5];
        in.readFully(bytes, 0, 1);
        int len = PackedInteger.getReadIntLength(bytes, 0);
        in.readFully(bytes, 1, len - 1);
        return PackedInteger.readInt(bytes, 0);
    }

    public static void writePackedInt(DataOutput out, int value) throws IOException {
        byte[] buf = new byte[5];
        int offset = PackedInteger.writeInt(buf, 0, value);
        out.write(buf, 0, offset);
    }

    public static long readPackedLong(DataInput in) throws IOException {
        byte[] bytes = new byte[9];
        in.readFully(bytes, 0, 1);
        int len = PackedInteger.getReadLongLength(bytes, 0);
        in.readFully(bytes, 1, len - 1);
        return PackedInteger.readLong(bytes, 0);
    }

    public static void writePackedLong(DataOutput out, long value) throws IOException {
        byte[] buf = new byte[9];
        int offset = PackedInteger.writeLong(buf, 0, value);
        out.write(buf, 0, offset);
    }

    public static String readString(DataInput in) throws IOException {
        int len = SerializationUtil.readPackedInt(in);
        if (len == -1) {
            return null;
        }
        byte[] bytes = new byte[len];
        if (len > 0) {
            in.readFully(bytes);
        }
        return SerializationUtil.utfToString(bytes);
    }

    public static void writeString(DataOutput out, String value) throws IOException {
        if (value == null) {
            SerializationUtil.writePackedInt(out, -1);
            return;
        }
        int utfLength = SerializationUtil.getUTFLength(value);
        SerializationUtil.writePackedInt(out, utfLength);
        if (utfLength > 0) {
            byte[] bytes = SerializationUtil.stringToUTF(value, utfLength);
            out.write(bytes);
        }
    }

    private static int getUTFLength(String s) {
        int len = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++len;
                continue;
            }
            if (c > '\u07ff') {
                len += 3;
                continue;
            }
            len += 2;
        }
        return len;
    }

    private static byte[] stringToUTF(String s, int utfLength) {
        char c;
        int i;
        int length = s.length();
        assert (length > 0);
        byte[] bytes = new byte[utfLength];
        int byteOffset = 0;
        for (i = 0; i < length && (c = s.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytes[byteOffset++] = (byte)c;
        }
        while (i < length) {
            if ((c = s.charAt(i++)) >= '\u0001' && c <= '\u007f') {
                bytes[byteOffset++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytes[byteOffset++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[byteOffset++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[byteOffset++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytes[byteOffset++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytes[byteOffset++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return bytes;
    }

    private static String utfToString(byte[] bytes) throws IllegalArgumentException, IndexOutOfBoundsException {
        int char1;
        int count;
        int len = bytes.length;
        if (len == 0) {
            return EMPTY_STRING;
        }
        char[] chars = new char[len];
        int charArrayCount = 0;
        for (count = 0; count < len && (char1 = bytes[count] & 0xFF) <= 127; ++count) {
            chars[charArrayCount++] = (char)char1;
        }
        block6: while (count < len) {
            char1 = bytes[count++] & 0xFF;
            switch (char1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charArrayCount++] = (char)char1;
                    continue block6;
                }
                case 12: 
                case 13: {
                    byte char2 = bytes[count++];
                    if ((char2 & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    chars[charArrayCount++] = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    byte char2 = bytes[count++];
                    byte char3 = bytes[count++];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    chars[charArrayCount++] = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new IllegalArgumentException();
        }
        return new String(chars, 0, charArrayCount);
    }
}

