/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;

public class JsonUtils {
    protected static final ObjectMapper mapper = new ObjectMapper();

    public static JsonParser createJsonParser(Reader in) throws IOException {
        return JsonUtils.enableFeatures(mapper.getJsonFactory().createJsonParser(in));
    }

    public static JsonParser createJsonParser(InputStream in) throws IOException {
        return JsonUtils.enableFeatures(mapper.getJsonFactory().createJsonParser(in));
    }

    private static JsonParser enableFeatures(JsonParser parser) {
        parser.enable(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS);
        return parser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }

    public static ObjectNode createObjectNode() {
        return mapper.createObjectNode();
    }

    public static ObjectWriter createWriter(boolean pretty) {
        return pretty ? mapper.defaultPrettyPrintingWriter() : mapper.writer();
    }

    public static String getAsText(JsonNode node, String field) {
        return JsonUtils.getAsText(node, field, null);
    }

    public static String getAsText(JsonNode node, String field, String defaultValue) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isValueNode()) {
            return defaultValue;
        }
        return fieldNode.asText();
    }

    public static Long getLong(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isLong()) {
            return null;
        }
        return fieldNode.getLongValue();
    }

    public static Integer getInt(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isInt()) {
            return null;
        }
        return fieldNode.getIntValue();
    }

    public static Double getDouble(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isDouble()) {
            return null;
        }
        return fieldNode.getDoubleValue();
    }

    public static Boolean getBoolean(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isBoolean()) {
            return null;
        }
        return fieldNode.getBooleanValue();
    }

    public static boolean getBoolean(JsonNode node, String field, boolean defaultValue) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isBoolean()) {
            return defaultValue;
        }
        return fieldNode.getBooleanValue();
    }

    public static ObjectNode getObject(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isObject()) {
            return null;
        }
        return (ObjectNode)fieldNode;
    }

    public static Iterable<JsonNode> getArray(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isArray()) {
            return Collections.emptyList();
        }
        return fieldNode;
    }

    public static boolean jsonStringsEqual(String a, String b) {
        Map<String, Object> mapa = JsonUtils.getMapFromJsonStr(a);
        Map<String, Object> mapb = JsonUtils.getMapFromJsonStr(b);
        if (mapa == null) {
            return false;
        }
        return mapa.equals(mapb);
    }

    public static Map<String, Object> getMapFromJsonStr(String s) {
        try {
            return mapper.readValue(s, HashMap.class);
        }
        catch (IOException e) {
            return null;
        }
    }
}

