/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RepGroupId
extends ResourceId
implements Comparable<RepGroupId> {
    public static RepGroupId NULL_ID = new RepGroupId(-1);
    private static final String REP_GROUP_PREFIX = "rg";
    private static final long serialVersionUID = 1L;
    private int groupId;

    public RepGroupId(int groupId) {
        this.groupId = groupId;
    }

    public RepGroupId(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.groupId = in.readInt();
    }

    public boolean isNull() {
        return this.groupId == RepGroupId.NULL_ID.groupId;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.groupId);
    }

    public static String getPrefix() {
        return REP_GROUP_PREFIX;
    }

    private RepGroupId() {
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.REP_GROUP;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return REP_GROUP_PREFIX + this.getGroupId();
    }

    public boolean sameGroup(RepNodeId repNodeId) {
        return this.groupId == repNodeId.getGroupId();
    }

    public static RepGroupId parse(String groupName) {
        return new RepGroupId(RepGroupId.parseForInt(REP_GROUP_PREFIX, groupName));
    }

    public String toString() {
        return this.getGroupName();
    }

    public RepGroup getComponent(Topology topology) {
        return topology.get(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepGroupId other = (RepGroupId)obj;
        return this.groupId == other.groupId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupId;
        return result;
    }

    @Override
    public int compareTo(RepGroupId other) {
        return this.getGroupId() - other.getGroupId();
    }

    public static RepGroupId getRepGroupId(ResourceId resId) {
        if (resId instanceof RepGroupId) {
            return new RepGroupId(((RepGroupId)resId).getGroupId());
        }
        return null;
    }
}

