/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ObjectUtil;

@Persistent(version=2)
public class Datacenter
extends Topology.Component<DatacenterId> {
    private static final long serialVersionUID = 1L;
    private static final DatacenterType DEFAULT_DATACENTER_TYPE = DatacenterType.PRIMARY;
    private String name;
    private int repFactor;
    private boolean allowArbiters;

    public static Datacenter newInstance(String name, int repFactor, DatacenterType datacenterType, boolean allowArbiters) {
        ObjectUtil.checkNull("datacenterType", (Object)datacenterType);
        switch (datacenterType) {
            case PRIMARY: {
                return new Datacenter(name, repFactor, allowArbiters);
            }
            case SECONDARY: {
                return new DatacenterV2(name, repFactor, datacenterType, allowArbiters);
            }
        }
        throw new AssertionError();
    }

    private Datacenter(String name, int repFactor, boolean allowArbiters) {
        this.name = name;
        this.repFactor = repFactor;
        this.allowArbiters = allowArbiters;
        int minRepFactor = 1;
        if (allowArbiters) {
            minRepFactor = 0;
        }
        if (repFactor < minRepFactor) {
            throw new IllegalArgumentException("Replication factor must be greater than or equal to " + minRepFactor);
        }
    }

    private Datacenter(Datacenter datacenter) {
        super(datacenter);
        this.name = datacenter.name;
        this.repFactor = datacenter.repFactor;
    }

    private Datacenter() {
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.DATACENTER;
    }

    public String getName() {
        return this.name;
    }

    public int getRepFactor() {
        return this.repFactor;
    }

    public void setRepFactor(int factor) {
        this.repFactor = factor;
    }

    public DatacenterType getDatacenterType() {
        return DEFAULT_DATACENTER_TYPE;
    }

    public boolean getAllowArbiters() {
        return this.allowArbiters;
    }

    @Override
    public Datacenter clone() {
        return new Datacenter(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.getDatacenterType().hashCode();
        result = 31 * result + this.getRepFactor();
        result = 31 * result + (this.getAllowArbiters() ? 0 : 1);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Datacenter)) {
            return false;
        }
        Datacenter other = (Datacenter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.repFactor == other.repFactor && this.getDatacenterType().equals((Object)other.getDatacenterType()) && this.allowArbiters == other.allowArbiters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=" + this.getResourceId() + " name=" + this.name + " repFactor=" + this.repFactor + " type=" + (Object)((Object)this.getDatacenterType()) + " allowArbiters=" + this.getAllowArbiters());
        return sb.toString();
    }

    @Persistent
    private static class DatacenterV2
    extends Datacenter {
        private static final long serialVersionUID = 1L;
        private DatacenterType datacenterType;

        DatacenterV2(String name, int repFactor, DatacenterType datacenterType, boolean allowArbiters) {
            super(name, repFactor, allowArbiters);
            ObjectUtil.checkNull("datacenterType", (Object)datacenterType);
            this.datacenterType = datacenterType;
        }

        private DatacenterV2(DatacenterV2 datacenter) {
            super(datacenter);
            this.datacenterType = datacenter.datacenterType;
        }

        private DatacenterV2() {
        }

        @Override
        public DatacenterType getDatacenterType() {
            return this.datacenterType;
        }

        @Override
        public DatacenterV2 clone() {
            return new DatacenterV2(this);
        }
    }
}

