/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.ArbNode;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class ArbNodeId
extends ResourceId
implements Comparable<ArbNodeId> {
    private static final long serialVersionUID = 1L;
    private static final String AR_PREFIX = "an";
    private final int groupId;
    private final int nodeNum;

    public ArbNodeId(int groupId, int nodeNum) {
        this.groupId = groupId;
        this.nodeNum = nodeNum;
    }

    private ArbNodeId() {
        throw new IllegalStateException("Should not be invoked");
    }

    public static String getPrefix() {
        return AR_PREFIX;
    }

    public ArbNodeId(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.groupId = in.readInt();
        this.nodeNum = in.readInt();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.groupId);
        out.writeInt(this.nodeNum);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.ARB_NODE;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    @Override
    public String getFullName() {
        return new RepGroupId(this.getGroupId()).getGroupName() + "-" + AR_PREFIX + this.getNodeNum();
    }

    public static ArbNodeId parse(String fullName) {
        String[] idArgs = fullName.split("-");
        if (idArgs.length == 2) {
            RepGroupId rgId = RepGroupId.parse(idArgs[0]);
            int nodeNum = ArbNodeId.parseForInt(AR_PREFIX, idArgs[1]);
            return new ArbNodeId(rgId.getGroupId(), nodeNum);
        }
        throw new IllegalArgumentException(fullName + " is not a valid ArbNode id. It must follow the format rgX-anY");
    }

    public String getGroupName() {
        return new RepGroupId(this.getGroupId()).getGroupName();
    }

    public String toString() {
        return this.getFullName();
    }

    public ArbNode getComponent(Topology topology) {
        return topology.get(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArbNodeId other = (ArbNodeId)obj;
        if (this.groupId != other.groupId) {
            return false;
        }
        return this.nodeNum == other.nodeNum;
    }

    @Override
    public int hashCode() {
        int prime = 41;
        int result = 1;
        result = 41 * result + this.groupId;
        result = 41 * result + this.nodeNum;
        return result;
    }

    @Override
    public int compareTo(ArbNodeId other) {
        int grp = this.getGroupId() - other.getGroupId();
        if (grp != 0) {
            return grp;
        }
        return this.getNodeNum() - other.getNodeNum();
    }
}

