/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class ArbNode
extends Topology.Component<ArbNodeId>
implements Comparable<ArbNode> {
    private static final long serialVersionUID = 1L;
    private final StorageNodeId storageNodeId;

    public ArbNode(StorageNodeId storageNodeId) {
        this.storageNodeId = storageNodeId;
    }

    private ArbNode(ArbNode arbNode) {
        super(arbNode);
        this.storageNodeId = arbNode.storageNodeId;
    }

    private ArbNode() {
        throw new IllegalStateException("Should not be invoked");
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.ARB_NODE;
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        result = 37 * result + (this.storageNodeId == null ? 0 : this.storageNodeId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArbNode other = (ArbNode)obj;
        return this.propertiesEquals(other);
    }

    public boolean propertiesEquals(ArbNode other) {
        return !(this.storageNodeId == null ? other.storageNodeId != null : !this.storageNodeId.equals(other.storageNodeId));
    }

    public RepGroupId getRepGroupId() {
        return new RepGroupId(((ArbNodeId)this.getResourceId()).getGroupId());
    }

    @Override
    public StorageNodeId getStorageNodeId() {
        return this.storageNodeId;
    }

    @Override
    public ArbNode clone() {
        return new ArbNode(this);
    }

    @Override
    public boolean isMonitorEnabled() {
        return true;
    }

    public String toString() {
        return "[" + this.getResourceId() + "]" + " sn=" + this.storageNodeId;
    }

    @Override
    public int compareTo(ArbNode other) {
        return ((ArbNodeId)this.getResourceId()).compareTo((ArbNodeId)other.getResourceId());
    }
}

