/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginToken;

public class KerberosLoginResult
extends LoginResult {
    private static final long serialVersionUID = 1L;
    private byte[] mutualAuthenToken;

    public KerberosLoginResult(byte[] token) {
        super(null);
        this.mutualAuthenToken = token;
    }

    public KerberosLoginResult(LoginToken loginToken, byte[] authenToken) {
        super(loginToken);
        this.mutualAuthenToken = authenToken;
    }

    public KerberosLoginResult(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short tokenLen = in.readShort();
        this.mutualAuthenToken = new byte[tokenLen];
        in.readFully(this.mutualAuthenToken);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.mutualAuthenToken.length);
        out.write(this.mutualAuthenToken);
    }

    public byte[] getMutualAuthToken() {
        return this.mutualAuthenToken;
    }
}

