/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.Consistency;
import oracle.kv.ParallelScanIterator;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.TableIterFactory;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.FieldValue;

public class RuntimeControlBlock {
    final Logger theLogger;
    final byte theTraceLevel;
    final PlanIter theRootIter;
    private final PlanIterState[] theIteratorStates;
    private final FieldValueImpl[] theRegisters;
    private final TableMetadata theTableMetadata;
    private final ExecuteOptions theExecuteOptions;
    final FieldValue[] theExternalVars;
    private final TableIterFactory theTableIterFactory;
    private final KVStoreImpl theStore;
    private byte[] thePrimaryResumeKey;
    private byte[] theSecondaryResumeKey;
    private long theNumResultsComputed;
    private ParallelScanIterator<FieldValueImpl> theTableIterator;
    private final Set<Integer> thePartitions;
    private final Set<RepGroupId> theShards;

    public RuntimeControlBlock(Logger logger, PlanIter rootIter, int numIters, int numRegs, TableMetadata tableMetadata, ExecuteOptions executeOptions, FieldValue[] externalVars, byte[] primaryResumeKey, byte[] secondaryResumeKey, long numResultsComputed, TableIterFactory tableIterFactory, KVStoreImpl store) {
        this(logger, rootIter, numIters, numRegs, tableMetadata, executeOptions, externalVars, primaryResumeKey, secondaryResumeKey, numResultsComputed, tableIterFactory, store, null, null);
    }

    public RuntimeControlBlock(Logger logger, PlanIter rootIter, int numIters, int numRegs, TableMetadata tableMetadata, ExecuteOptions executeOptions, FieldValue[] externalVars, byte[] primaryResumeKey, byte[] secondaryResumeKey, long numResultsComputed, TableIterFactory tableIterFactory, KVStoreImpl store, Set<Integer> partitions, Set<RepGroupId> shards) {
        this.theLogger = logger;
        this.theRootIter = rootIter;
        this.theTraceLevel = executeOptions != null ? executeOptions.getTraceLevel() : (byte)0;
        this.theIteratorStates = new PlanIterState[numIters];
        this.theRegisters = new FieldValueImpl[numRegs];
        this.theTableMetadata = tableMetadata;
        this.theExecuteOptions = executeOptions;
        this.theExternalVars = externalVars;
        this.thePrimaryResumeKey = primaryResumeKey;
        this.theSecondaryResumeKey = secondaryResumeKey;
        this.theNumResultsComputed = numResultsComputed;
        this.theTableIterFactory = tableIterFactory;
        this.theStore = store;
        this.thePartitions = partitions;
        this.theShards = shards;
    }

    public Logger getLogger() {
        return this.theLogger;
    }

    byte getTraceLevel() {
        return this.theTraceLevel;
    }

    public void trace(String msg, int level) {
        if (this.theTraceLevel >= level) {
            this.theLogger.info(msg);
        }
    }

    public TableMetadata getTableMetadata() {
        return this.theTableMetadata;
    }

    public ExecuteOptions getExecuteOptions() {
        return this.theExecuteOptions;
    }

    Consistency getConsistency() {
        return this.theExecuteOptions != null ? this.theExecuteOptions.getConsistency() : null;
    }

    long getTimeout() {
        return this.theExecuteOptions != null ? this.theExecuteOptions.getTimeout() : 0L;
    }

    TimeUnit getTimeUnit() {
        return this.theExecuteOptions != null ? this.theExecuteOptions.getTimeoutUnit() : null;
    }

    public void setState(int pos, PlanIterState state) {
        this.theIteratorStates[pos] = state;
    }

    public PlanIterState getState(int pos) {
        return this.theIteratorStates[pos];
    }

    public FieldValueImpl[] getRegisters() {
        return this.theRegisters;
    }

    public FieldValueImpl getRegVal(int regId) {
        return this.theRegisters[regId];
    }

    public void setRegVal(int regId, FieldValueImpl value) {
        this.theRegisters[regId] = value;
    }

    FieldValue[] getExternalVars() {
        return this.theExternalVars;
    }

    FieldValueImpl getExternalVar(int id) {
        if (this.theExternalVars == null) {
            return null;
        }
        return (FieldValueImpl)this.theExternalVars[id];
    }

    protected void setTableIterator(ParallelScanIterator<FieldValueImpl> iter) {
        this.theTableIterator = iter;
    }

    public ParallelScanIterator<FieldValueImpl> getTableIterator() {
        return this.theTableIterator;
    }

    public byte[] getPrimaryResumeKey() {
        return this.thePrimaryResumeKey;
    }

    public void setPrimaryResumeKey(byte[] resumeKey) {
        this.thePrimaryResumeKey = resumeKey;
    }

    public byte[] getSecondaryResumeKey() {
        return this.theSecondaryResumeKey;
    }

    public void setSecondaryResumeKey(byte[] resumeKey) {
        this.theSecondaryResumeKey = resumeKey;
    }

    long getNumResultsComputed() {
        return this.theNumResultsComputed;
    }

    public KVStoreImpl getStore() {
        return this.theStore;
    }

    TableIterFactory getTableIterFactory() {
        return this.theTableIterFactory;
    }

    public Set<Integer> getPartitionSet() {
        return this.thePartitions;
    }

    public Set<RepGroupId> getShardSet() {
        return this.theShards;
    }
}

