/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class NotIter
extends PlanIter {
    private final FunctionLib.FuncCode theCode;
    private final PlanIter theArg;

    public NotIter(Expr e, int resultReg, FunctionLib.FuncCode code, PlanIter argIter) {
        super(e, resultReg);
        this.theCode = code;
        this.theArg = argIter;
    }

    public NotIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = in.readShort();
        this.theCode = FunctionLib.FuncCode.values()[ordinal];
        this.theArg = NotIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theCode.ordinal());
        NotIter.serializeIter(this.theArg, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.NOT;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        this.theArg.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FieldValueImpl res;
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theArg.next(rcb);
        if (!more) {
            res = BooleanValueImpl.trueValue;
        } else {
            FieldValueImpl value = rcb.getRegVal(this.theArg.getResultReg());
            if (value.isNull()) {
                res = NullValueImpl.getInstance();
            } else if (value == BooleanValueImpl.falseValue) {
                res = BooleanValueImpl.trueValue;
            } else {
                assert (value == BooleanValueImpl.trueValue);
                res = BooleanValueImpl.falseValue;
            }
        }
        rcb.setRegVal(this.theResultReg, res);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theArg.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theArg.close(rcb);
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theArg.display(sb, formatter);
    }
}

