/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Stack;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldDef;

public class FieldStepIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final PlanIter theFieldNameIter;
    private final String theFieldName;
    private final int theFieldPos;
    private final int theCtxItemReg;

    public FieldStepIter(Expr e, int resultReg, PlanIter inputIter, PlanIter fieldNameIter, String fieldName, int fieldPos, int ctxItemReg) {
        super(e, resultReg);
        this.theInputIter = inputIter;
        this.theFieldNameIter = fieldNameIter;
        this.theFieldName = fieldName;
        this.theFieldPos = fieldPos;
        this.theCtxItemReg = ctxItemReg;
    }

    FieldStepIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theCtxItemReg = in.readInt();
        this.theFieldPos = in.readInt();
        this.theInputIter = FieldStepIter.deserializeIter(in, serialVersion);
        this.theFieldName = SerializationUtil.readString(in);
        boolean fieldNameIterExists = in.readBoolean();
        this.theFieldNameIter = fieldNameIterExists ? FieldStepIter.deserializeIter(in, serialVersion) : null;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.theCtxItemReg);
        out.writeInt(this.theFieldPos);
        FieldStepIter.serializeIter(this.theInputIter, out, serialVersion);
        SerializationUtil.writeString(out, this.theFieldName);
        if (this.theFieldNameIter != null) {
            out.writeBoolean(true);
            FieldStepIter.serializeIter(this.theFieldNameIter, out, serialVersion);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FIELD_STEP;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new FieldStepState(this));
        this.theInputIter.open(rcb);
        if (this.theFieldNameIter != null) {
            this.theFieldNameIter.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FieldValueImpl result;
        FieldStepState state = (FieldStepState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (this.theFieldPos >= 0 && state.theHasTupleInput) {
            assert (this.theFieldName != null);
            assert (this.theInputIter.getTupleRegs() != null);
            boolean more = this.theInputIter.next(rcb);
            if (!more) {
                state.done();
                return false;
            }
            return true;
        }
        if (this.theFieldName == null && this.theCtxItemReg < 0) {
            this.computeFieldName(rcb, state, null, false);
            if (state.theFieldName == null) {
                state.done();
                return false;
            }
        }
        while (true) {
            FieldDef.Type ctxItemKind;
            FieldValueImpl ctxItem = null;
            if (state.theArrays.isEmpty()) {
                boolean more = this.theInputIter.next(rcb);
                if (!more) {
                    state.done();
                    return false;
                }
                int inputReg = this.theInputIter.getResultReg();
                ctxItem = rcb.getRegVal(inputReg);
                if (ctxItem.isAtomic()) continue;
                if (ctxItem.isNull()) {
                    rcb.setRegVal(this.theResultReg, ctxItem);
                    return true;
                }
                ctxItemKind = ctxItem.getType();
            } else {
                ArrayAndPos arrayCtx = state.theArrays.peek();
                ArrayValueImpl array = arrayCtx.theArray;
                ctxItem = array.getElement(arrayCtx.thePos);
                ctxItemKind = ctxItem.getType();
                ++arrayCtx.thePos;
                if (arrayCtx.thePos >= array.size()) {
                    state.theArrays.pop();
                }
                if (ctxItem.isAtomic()) continue;
            }
            if (ctxItemKind == FieldDef.Type.ARRAY) {
                ArrayValueImpl array = (ArrayValueImpl)ctxItem;
                if (array.size() <= 0) continue;
                ArrayAndPos arrayCtx = new ArrayAndPos(array);
                state.theArrays.push(arrayCtx);
                continue;
            }
            if (ctxItemKind != FieldDef.Type.RECORD && ctxItemKind != FieldDef.Type.MAP) {
                throw new QueryException("Input value in field step has invalid type.\nExpected a complex type. Actual type is:\n" + ctxItem.getDefinition(), this.getLocation());
            }
            if (this.theCtxItemReg >= 0) {
                this.computeFieldName(rcb, state, ctxItem, true);
                if (state.theFieldName == null) continue;
            }
            if (ctxItemKind == FieldDef.Type.RECORD) {
                if (this.theFieldPos >= 0) {
                    if (ctxItem.isTuple()) {
                        TupleValue tuple = (TupleValue)ctxItem;
                        result = tuple.get(this.theFieldPos);
                    } else {
                        RecordValueImpl rec = (RecordValueImpl)ctxItem;
                        result = rec.get(this.theFieldPos);
                    }
                } else if (ctxItem.isTuple()) {
                    TupleValue tuple = (TupleValue)ctxItem;
                    result = tuple.getFieldValue(state.theFieldName);
                } else {
                    RecordValueImpl rec = (RecordValueImpl)ctxItem;
                    result = rec.get(state.theFieldName);
                }
                if (result != null) break;
                throw new QueryException("There is no field named " + state.theFieldName + " in type\n" + ctxItem.getDefinition(), this.getLocation());
            }
            assert (ctxItemKind == FieldDef.Type.MAP);
            MapValueImpl map = (MapValueImpl)ctxItem;
            result = map.get(state.theFieldName);
            if (result != null) break;
        }
        rcb.setRegVal(this.theResultReg, result);
        return true;
    }

    void computeFieldName(RuntimeControlBlock rcb, FieldStepState state, FieldValueImpl ctxItem, boolean reset) {
        boolean more;
        if (reset) {
            this.theFieldNameIter.reset(rcb);
        }
        if (this.theCtxItemReg >= 0) {
            rcb.setRegVal(this.theCtxItemReg, ctxItem);
        }
        if (!(more = this.theFieldNameIter.next(rcb))) {
            state.theFieldName = null;
            return;
        }
        int nameReg = this.theFieldNameIter.getResultReg();
        FieldValueImpl name = rcb.getRegVal(nameReg);
        state.theFieldName = name.isNull() ? null : name.getString();
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        if (this.theFieldNameIter != null) {
            this.theFieldNameIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        if (this.theFieldNameIter != null) {
            this.theFieldNameIter.close(rcb);
        }
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        sb.append(",\n");
        if (this.theFieldNameIter != null) {
            this.theFieldNameIter.display(sb, formatter);
        } else {
            formatter.indent(sb);
            sb.append(this.theFieldName);
        }
        sb.append(",\n");
        formatter.indent(sb);
        sb.append("theFieldPos : ").append(this.theFieldPos);
        if (this.theCtxItemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxItemReg : ").append(this.theCtxItemReg);
        }
    }

    private static class FieldStepState
    extends PlanIterState {
        final boolean theHasTupleInput;
        Stack<ArrayAndPos> theArrays = new Stack();
        String theFieldName;

        FieldStepState(FieldStepIter iter) {
            this.theFieldName = iter.theFieldName;
            this.theHasTupleInput = iter.theInputIter.producesTuples();
        }

        @Override
        protected void reset(PlanIter iter) {
            super.reset(iter);
            if (this.theArrays != null) {
                this.theArrays.clear();
            }
            this.theFieldName = ((FieldStepIter)iter).theFieldName;
        }

        @Override
        protected void close() {
            super.close();
            this.theArrays = null;
            this.theFieldName = null;
        }
    }

    private static class ArrayAndPos {
        ArrayValueImpl theArray;
        int thePos;

        ArrayAndPos(ArrayValueImpl array) {
            this.theArray = array;
            this.thePos = 0;
        }
    }
}

