/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataOutput;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.BaseTableIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.runtime.TableIterFactory;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.FieldRange;
import oracle.kv.table.IndexKey;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableIteratorOptions;

public class ClientTableIter
extends BaseTableIter {
    private final TableAPI theTableAPI;
    private final TableImpl theTable;

    private ClientTableIter(RuntimeControlBlock rcb, TableAPI tableAPI, QueryException.Location loc, int statePos, int resultReg, int[] tupleRegs, String tableName, String indexName, RecordDefImpl typeDef, Direction dir, RecordValueImpl primKey, RecordValueImpl secKey, FieldRange range, PlanIter filterIter, boolean usesCoveringIndex, boolean eliminateIndexDups, PlanIter[] pushedExternals) {
        super(loc, statePos, resultReg, tupleRegs, tableName, indexName, typeDef, dir, primKey, secKey, range, filterIter, usesCoveringIndex, eliminateIndexDups, pushedExternals);
        this.theTableAPI = tableAPI;
        this.theTable = rcb.getTableMetadata().getTable(this.theTableName);
        if (this.theTable == null) {
            throw new IllegalArgumentException("Table does not exist: " + this.theTableName);
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) {
        this.throwCannotCall("writeFastExternal");
    }

    @Override
    protected TableImpl getTable() {
        return this.theTable;
    }

    @Override
    public int[] getTupleRegs() {
        this.throwCannotCall("getTupleRegs");
        return null;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        TupleValue tuple = new TupleValue(this.theTypeDef, rcb.getRegisters(), this.theTupleRegs);
        rcb.setRegVal(this.theResultReg, tuple);
        rcb.setState(this.theStatePos, new ClientTableIterState(this.theTableAPI, rcb, this));
        if (this.theFilterIter != null) {
            this.theFilterIter.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        ClientTableIterState state = (ClientTableIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        assert (this.theTable != null);
        TableIterator iterator = state.ensureIterator();
        TupleValue tuple = (TupleValue)rcb.getRegVal(this.theResultReg);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            tuple.toTuple((RowImpl)row);
            if (this.theFilterIter != null) {
                boolean match = this.theFilterIter.next(rcb);
                this.theFilterIter.reset(rcb);
                if (!match) continue;
            }
            return true;
        }
        state.done();
        return false;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        ClientTableIterState state = (ClientTableIterState)rcb.getState(this.theStatePos);
        state.reset(this);
        if (this.theFilterIter != null) {
            this.theFilterIter.reset(rcb);
        }
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        ClientTableIterState state = (ClientTableIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
        if (this.theFilterIter != null) {
            this.theFilterIter.close(rcb);
        }
    }

    @Override
    protected void display(StringBuilder sb, QueryFormatter formatter) {
        this.throwCannotCall("display");
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.throwCannotCall("displayContent");
    }

    private void throwCannotCall(String method) {
        throw new QueryStateException("ClientTableIter: " + method + " cannot be called");
    }

    private static TableIterator<Row> tableIterator(TableAPI tableAPI, RuntimeControlBlock rcb, Direction dir, PrimaryKey key, FieldRange range) {
        MultiRowOptions mro = range != null ? range.createMultiRowOptions() : null;
        ExecuteOptions options = rcb.getExecuteOptions();
        TableIteratorOptions tio = options != null ? options.createTableIteratorOptions(dir) : new TableIteratorOptions(dir, null, 0L, null);
        return tableAPI.tableIterator(key, mro, tio);
    }

    private static TableIterator<Row> indexIterator(TableAPI tableAPI, RuntimeControlBlock rcb, Direction dir, IndexKey indexKey, FieldRange range) {
        MultiRowOptions mro = range != null ? range.createMultiRowOptions() : null;
        ExecuteOptions options = rcb.getExecuteOptions();
        TableIteratorOptions tio = options != null ? options.createTableIteratorOptions(dir) : new TableIteratorOptions(dir, null, 0L, null);
        return tableAPI.tableIterator(indexKey, mro, tio);
    }

    public static class ClientTableIterFactory
    implements TableIterFactory {
        private final TableAPI theTableAPI;

        public ClientTableIterFactory(TableAPI tableAPI) {
            this.theTableAPI = tableAPI;
        }

        @Override
        public PlanIter createTableIter(RuntimeControlBlock rcb, QueryException.Location loc, int statePos, int resultReg, int[] tupleRegs, String tableName, String indexName, RecordDefImpl typeDefinition, Direction direction, RecordValueImpl primKeyRecord, RecordValueImpl secKeyRecord, FieldRange range, PlanIter filterIter, boolean usesCoveringIndex, boolean eliminateIndexDups, PlanIter[] pushedExternals) {
            return new ClientTableIter(rcb, this.theTableAPI, loc, statePos, resultReg, tupleRegs, tableName, indexName, typeDefinition, direction, primKeyRecord, secKeyRecord, range, filterIter, usesCoveringIndex, eliminateIndexDups, pushedExternals);
        }
    }

    private static class ClientTableIterState
    extends BaseTableIter.BaseTableIterState {
        private final TableAPI theTableAPI;
        private TableIterator<Row> theIterator;

        ClientTableIterState(TableAPI tableAPI, RuntimeControlBlock rcb, ClientTableIter iter) {
            super(rcb, iter);
            this.theTableAPI = tableAPI;
        }

        private TableIterator<Row> ensureIterator() {
            if (this.theIterator == null) {
                this.theIterator = this.theSecondaryKey != null ? ClientTableIter.indexIterator(this.theTableAPI, this.theRCB, this.theDirection, this.theSecondaryKey, this.theRange) : ClientTableIter.tableIterator(this.theTableAPI, this.theRCB, this.theDirection, this.thePrimaryKey, this.theRange);
            }
            return this.theIterator;
        }

        @Override
        protected void reset(PlanIter iter) {
            super.reset(iter);
            if (this.theIterator != null) {
                this.theIterator.close();
                this.theIterator = null;
            }
        }

        @Override
        protected void close() {
            super.close();
            if (this.theIterator != null) {
                this.theIterator.close();
                this.theIterator = null;
            }
        }
    }
}

