/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.runtime.TableIterFactory;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;

public class BaseTableIter
extends PlanIter {
    protected final String theTableName;
    protected final String theIndexName;
    protected final RecordDefImpl theTypeDef;
    protected final Direction theDirection;
    protected final RecordValueImpl thePrimKey;
    protected final RecordValueImpl theSecKey;
    protected final FieldRange theRange;
    protected PlanIter theFilterIter;
    protected final boolean theUsesCoveringIndex;
    protected final boolean theEliminateIndexDups;
    protected final PlanIter[] thePushedExternals;
    protected final int[] theTupleRegs;
    protected PlanIter theTableIter;

    public BaseTableIter(Expr e, int resultReg, int[] tupleRegs, TableImpl table, Direction dir, PrimaryKeyImpl primKey, IndexKeyImpl secKey, FieldRange range, boolean usesCoveringIndex, boolean eliminateIndexDups, PlanIter[] pushedExternals) {
        super(e, resultReg);
        assert (primKey == null || secKey == null);
        assert (range == null || primKey != null || secKey != null);
        this.theTableName = table.getFullName();
        this.theTypeDef = (RecordDefImpl)e.getType().getDef();
        this.theDirection = dir;
        if (primKey == null && secKey == null) {
            this.thePrimKey = table.createPrimaryKey();
            this.theSecKey = null;
            this.theIndexName = null;
        } else if (primKey != null) {
            this.thePrimKey = primKey.getDefinition().createRecord();
            this.thePrimKey.copyFrom(primKey);
            this.theSecKey = null;
            this.theIndexName = null;
        } else {
            this.thePrimKey = null;
            this.theSecKey = secKey.clone();
            this.theIndexName = secKey.getIndex().getName();
        }
        this.theRange = range;
        this.theUsesCoveringIndex = usesCoveringIndex;
        this.theEliminateIndexDups = eliminateIndexDups;
        this.thePushedExternals = pushedExternals;
        this.theTupleRegs = tupleRegs;
    }

    protected BaseTableIter(QueryException.Location loc, int statePos, int resultReg, int[] tupleRegs, String tableName, String indexName, RecordDefImpl typeDef, Direction dir, RecordValueImpl primKey, RecordValueImpl secKey, FieldRange range, PlanIter filterIter, boolean usesCoveringIndex, boolean eliminateIndexDups, PlanIter[] pushedExternals) {
        super(statePos, resultReg, loc);
        this.theTableName = tableName;
        this.theIndexName = indexName;
        this.theTypeDef = typeDef;
        this.theDirection = dir;
        this.thePrimKey = primKey;
        this.theSecKey = secKey;
        this.theRange = range;
        this.theFilterIter = filterIter;
        this.theUsesCoveringIndex = usesCoveringIndex;
        this.theEliminateIndexDups = eliminateIndexDups;
        this.thePushedExternals = pushedExternals;
        this.theTupleRegs = tupleRegs;
    }

    BaseTableIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theTableName = SerializationUtil.readString(in);
        this.theIndexName = SerializationUtil.readString(in);
        this.theTypeDef = (RecordDefImpl)BaseTableIter.deserializeFieldDef(in, serialVersion);
        short ordinal = in.readShort();
        this.theDirection = Direction.valueOf(ordinal);
        if (this.theIndexName == null) {
            this.thePrimKey = BaseTableIter.deserializeKey(in, serialVersion);
            this.theSecKey = null;
        } else {
            this.thePrimKey = null;
            this.theSecKey = BaseTableIter.deserializeKey(in, serialVersion);
        }
        this.theRange = BaseTableIter.deserializeFieldRange(in, serialVersion);
        this.theUsesCoveringIndex = in.readBoolean();
        this.theEliminateIndexDups = serialVersion < 12 ? false : in.readBoolean();
        this.thePushedExternals = BaseTableIter.deserializeIters(in, serialVersion);
        this.theFilterIter = BaseTableIter.deserializeIter(in, serialVersion);
        this.theTupleRegs = BaseTableIter.deserializeIntArray(in);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, this.theTableName);
        SerializationUtil.writeString(out, this.theIndexName);
        BaseTableIter.serializeFieldDef(this.theTypeDef, out, serialVersion);
        out.writeShort(this.theDirection.ordinal());
        if (this.theIndexName == null) {
            BaseTableIter.serializeKey(this.thePrimKey, out, serialVersion);
        } else {
            BaseTableIter.serializeKey(this.theSecKey, out, serialVersion);
        }
        BaseTableIter.serializeFieldRange(this.theRange, out, serialVersion);
        out.writeBoolean(this.theUsesCoveringIndex);
        if (serialVersion >= 12) {
            out.writeBoolean(this.theEliminateIndexDups);
        }
        BaseTableIter.serializeIters(this.thePushedExternals, out, serialVersion);
        BaseTableIter.serializeIter(this.theFilterIter, out, serialVersion);
        BaseTableIter.serializeIntArray(this.theTupleRegs, out);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.BASE_TABLE;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theTupleRegs;
    }

    protected TableImpl getTable() {
        throw new ClassCastException("getTable method should only be called on a ClientTableIter or a ServerTableIter");
    }

    public void setFilterIter(PlanIter iter) {
        this.theFilterIter = iter;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        if (this.theTableIter == null) {
            TableIterFactory tableIterFactory = rcb.getTableIterFactory();
            this.theTableIter = tableIterFactory.createTableIter(rcb, this.getLocation(), this.theStatePos, this.theResultReg, this.theTupleRegs, this.theTableName, this.theIndexName, this.theTypeDef, this.theDirection, this.thePrimKey, this.theSecKey, this.theRange, this.theFilterIter, this.theUsesCoveringIndex, this.theEliminateIndexDups, this.thePushedExternals);
        }
        this.theTableIter.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        boolean retVal = false;
        if (this.theTableIter != null) {
            retVal = this.theTableIter.next(rcb);
        }
        return retVal;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        if (this.theTableIter != null) {
            this.theTableIter.reset(rcb);
        }
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        if (this.theTableIter != null) {
            this.theTableIter.close(rcb);
        }
    }

    @Override
    protected void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append((Object)this.getKind());
        this.displayRegs(sb);
        this.displayContent(sb, formatter);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        if (this.thePrimKey != null && this.thePrimKey.size() > 0 || this.theSecKey != null || this.theRange != null || this.theFilterIter != null) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("[\n");
            formatter.incIndent();
            formatter.indent(sb);
            sb.append(this.theTableName);
            if (this.thePrimKey != null) {
                if (this.theUsesCoveringIndex) {
                    sb.append(" via covering primary index");
                } else {
                    sb.append(" via primary index");
                }
                sb.append("\n");
                formatter.indent(sb);
                sb.append("KEY: ");
                sb.append(this.thePrimKey);
            }
            if (this.theSecKey != null) {
                if (this.theUsesCoveringIndex) {
                    sb.append(" via covering index ");
                } else {
                    sb.append(" via index ");
                }
                sb.append(this.theIndexName);
                if (this.theEliminateIndexDups) {
                    sb.append(" with duplicate elimination");
                }
                sb.append("\n");
                formatter.indent(sb);
                sb.append("SEC KEY: ");
                sb.append(this.theSecKey);
            }
            if (this.theRange != null) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append("RANGE: ");
                sb.append(this.theRange);
            }
            if (this.theFilterIter != null) {
                sb.append("\n\n");
                formatter.indent(sb);
                sb.append("Filtering Predicate:\n");
                this.theFilterIter.display(sb, formatter);
            }
            if (this.thePushedExternals != null) {
                sb.append("\n\n");
                formatter.indent(sb);
                sb.append("EXTERNAL KEY EXPRS: ");
                sb.append(this.thePushedExternals.length);
                for (PlanIter iter : this.thePushedExternals) {
                    sb.append("\n");
                    if (iter != null) {
                        iter.display(sb, formatter);
                        continue;
                    }
                    formatter.indent(sb);
                    sb.append("null");
                }
            }
            formatter.decIndent();
            sb.append("\n");
            formatter.indent(sb);
            sb.append("]");
        } else {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("[");
            sb.append(this.theTableName);
            if (this.theUsesCoveringIndex) {
                sb.append(" via covering primary index");
            } else {
                sb.append(" via primary index");
            }
            sb.append("]");
        }
    }

    static FieldValueImpl castValueToIndexKey(TableImpl table, IndexImpl index, int keyPos, FieldValueImpl val, FunctionLib.FuncCode opcode) {
        if (index != null) {
            return FuncCompOp.castConstInCompOp(index.getFieldDef(keyPos), val, opcode, false);
        }
        return FuncCompOp.castConstInCompOp(table.getPrimKeyColumnDef(keyPos), val, opcode, false);
    }

    public static class BaseTableIterState
    extends PlanIterState {
        protected final RuntimeControlBlock theRCB;
        protected final Direction theDirection;
        protected final PrimaryKeyImpl thePrimaryKey;
        protected final IndexKeyImpl theSecondaryKey;
        protected final FieldRange theRange;
        protected boolean theAlwaysFalse;

        protected BaseTableIterState(RuntimeControlBlock rcb, BaseTableIter iter) {
            IndexImpl index;
            this.theRCB = rcb;
            this.theDirection = iter.theDirection;
            TableImpl table = iter.getTable();
            IndexImpl indexImpl = index = iter.theIndexName != null ? (IndexImpl)table.getIndex(iter.theIndexName) : null;
            if (index != null) {
                this.theSecondaryKey = index.createIndexKeyFromFlattenedRecord(iter.theSecKey);
                this.thePrimaryKey = null;
            } else {
                assert (iter.thePrimKey != null);
                this.thePrimaryKey = table.createPrimaryKey(iter.thePrimKey);
                this.theSecondaryKey = null;
            }
            if (iter.thePushedExternals == null || iter.thePushedExternals.length == 0) {
                this.theRange = iter.theRange;
                return;
            }
            int size = iter.thePushedExternals.length;
            if (iter.theRange != null) {
                FieldValueImpl newVal;
                FieldValueImpl val;
                FieldRange range = iter.theRange.clone();
                PlanIter lowIter = iter.thePushedExternals[size - 2];
                PlanIter highIter = iter.thePushedExternals[size - 1];
                size -= 2;
                if (lowIter != null) {
                    lowIter.open(rcb);
                    lowIter.next(rcb);
                    val = rcb.getRegVal(lowIter.getResultReg());
                    lowIter.close(rcb);
                    newVal = BaseTableIter.castValueToIndexKey(table, index, size, val, FunctionLib.FuncCode.OP_GE);
                    if (newVal != val) {
                        if (newVal == BooleanValueImpl.falseValue) {
                            this.theAlwaysFalse = true;
                            this.theRange = null;
                            return;
                        }
                        val = newVal == BooleanValueImpl.trueValue ? null : newVal;
                    }
                    range.setStart(val, range.getStartInclusive(), false);
                    if (!range.check()) {
                        this.theAlwaysFalse = true;
                        this.theRange = null;
                        return;
                    }
                }
                if (highIter != null) {
                    highIter.open(rcb);
                    highIter.next(rcb);
                    val = rcb.getRegVal(highIter.getResultReg());
                    highIter.close(rcb);
                    newVal = BaseTableIter.castValueToIndexKey(table, index, size, val, FunctionLib.FuncCode.OP_LE);
                    if (newVal != val) {
                        if (newVal == BooleanValueImpl.falseValue) {
                            this.theAlwaysFalse = true;
                            this.theRange = null;
                            return;
                        }
                        val = newVal == BooleanValueImpl.trueValue ? null : newVal;
                    }
                    range.setEnd(val, range.getEndInclusive(), false);
                    if (!range.check()) {
                        this.theAlwaysFalse = true;
                        this.theRange = null;
                        return;
                    }
                }
                this.theRange = range.getStart() != null || range.getEnd() != null ? range : null;
            } else {
                this.theRange = null;
            }
            for (int i = 0; i < size; ++i) {
                PlanIter extIter = iter.thePushedExternals[i];
                if (extIter == null) continue;
                extIter.open(rcb);
                extIter.next(rcb);
                FieldValueImpl val = rcb.getRegVal(extIter.getResultReg());
                extIter.close(rcb);
                FieldValueImpl newVal = BaseTableIter.castValueToIndexKey(table, index, i, val, FunctionLib.FuncCode.OP_EQ);
                if (newVal != val) {
                    if (newVal == BooleanValueImpl.falseValue) {
                        this.theAlwaysFalse = true;
                        return;
                    }
                    assert (newVal != BooleanValueImpl.trueValue);
                    val = newVal;
                }
                if (index != null) {
                    this.theSecondaryKey.put(i, (FieldValue)val);
                    continue;
                }
                assert (this.thePrimaryKey != null);
                this.thePrimaryKey.put(i, (FieldValue)val);
            }
        }

        public boolean isAlwaysFalse() {
            return this.theAlwaysFalse;
        }
    }
}

