/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.table.FieldDef;

public class ArithOpIter
extends PlanIter {
    private final FunctionLib.FuncCode theCode;
    private final PlanIter[] theArgs;
    private final String theOps;

    public ArithOpIter(Expr e, int resultReg, FunctionLib.FuncCode code, PlanIter[] argIters, String theOps) {
        super(e, resultReg);
        this.theCode = code;
        assert ((this.theCode == FunctionLib.FuncCode.OP_ADD_SUB || this.theCode == FunctionLib.FuncCode.OP_MULT_DIV) && argIters.length >= 2);
        this.theArgs = argIters;
        this.theOps = theOps;
    }

    public ArithOpIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = in.readShort();
        this.theCode = FunctionLib.FuncCode.values()[ordinal];
        this.theArgs = ArithOpIter.deserializeIters(in, serialVersion);
        this.theOps = in.readUTF();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theCode.ordinal());
        ArithOpIter.serializeIters(this.theArgs, out, serialVersion);
        out.writeUTF(this.theOps);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.ARITH_OP;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        for (PlanIter argIter : this.theArgs) {
            argIter.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        FieldDef.Type resultType = FieldDef.Type.INTEGER;
        block42: for (int i = 0; i < this.theArgs.length; ++i) {
            PlanIter argIter = this.theArgs[i];
            boolean opNext = argIter.next(rcb);
            if (!opNext) {
                state.done();
                return false;
            }
            FieldValueImpl argValue = rcb.getRegVal(argIter.getResultReg());
            if (argValue.isNull()) {
                NullValueImpl res = NullValueImpl.getInstance();
                rcb.setRegVal(this.theResultReg, res);
                state.done();
                return true;
            }
            FieldDef.Type argType = argValue.getType();
            switch (argType) {
                case INTEGER: {
                    continue block42;
                }
                case LONG: {
                    if (resultType != FieldDef.Type.INTEGER) continue block42;
                    resultType = FieldDef.Type.LONG;
                    continue block42;
                }
                case FLOAT: {
                    if (resultType != FieldDef.Type.INTEGER && resultType != FieldDef.Type.LONG) continue block42;
                    resultType = FieldDef.Type.FLOAT;
                    continue block42;
                }
                case DOUBLE: {
                    resultType = FieldDef.Type.DOUBLE;
                    continue block42;
                }
                default: {
                    throw new QueryException("Operand in arithmetic operation has illegal type\nOperand : " + i + " type : " + argValue.getDefinition().getDDLString(), this.getLocation());
                }
            }
        }
        assert (this.theOps.length() == this.theArgs.length) : "Not enough operations: ops:" + (this.theOps.length() - 1) + " args:" + this.theArgs.length;
        int iRes = 0;
        long lRes = 0L;
        float fRes = 0.0f;
        double dRes = 0.0;
        switch (this.theCode) {
            case OP_ADD_SUB: {
                iRes = 0;
                lRes = 0;
                fRes = lRes;
                dRes = fRes;
                break;
            }
            case OP_MULT_DIV: {
                iRes = 1;
                lRes = 1;
                fRes = lRes;
                dRes = fRes;
                break;
            }
            default: {
                throw new QueryStateException("Invalid operation code: " + (Object)((Object)this.theCode));
            }
        }
        try {
            block43: for (int i = 0; i < this.theArgs.length; ++i) {
                boolean addOrMult;
                PlanIter argIter = this.theArgs[i];
                FieldValueImpl argValue = rcb.getRegVal(argIter.getResultReg());
                assert (argValue != null);
                boolean bl = addOrMult = this.theOps.charAt(i) == '+' || this.theOps.charAt(i) == '*';
                if (this.theCode == FunctionLib.FuncCode.OP_ADD_SUB) {
                    if (addOrMult) {
                        switch (resultType) {
                            case INTEGER: {
                                iRes += argValue.castAsInt();
                                continue block43;
                            }
                            case LONG: {
                                lRes += argValue.castAsLong();
                                continue block43;
                            }
                            case FLOAT: {
                                fRes += argValue.castAsFloat();
                                continue block43;
                            }
                            case DOUBLE: {
                                dRes += argValue.castAsDouble();
                                continue block43;
                            }
                            default: {
                                assert (false);
                                continue block43;
                            }
                        }
                    }
                    switch (resultType) {
                        case INTEGER: {
                            iRes -= argValue.castAsInt();
                            continue block43;
                        }
                        case LONG: {
                            lRes -= argValue.castAsLong();
                            continue block43;
                        }
                        case FLOAT: {
                            fRes -= argValue.castAsFloat();
                            continue block43;
                        }
                        case DOUBLE: {
                            dRes -= argValue.castAsDouble();
                            continue block43;
                        }
                        default: {
                            assert (false);
                            continue block43;
                        }
                    }
                }
                if (addOrMult) {
                    switch (resultType) {
                        case INTEGER: {
                            iRes *= argValue.castAsInt();
                            continue block43;
                        }
                        case LONG: {
                            lRes *= argValue.castAsLong();
                            continue block43;
                        }
                        case FLOAT: {
                            fRes *= argValue.castAsFloat();
                            continue block43;
                        }
                        case DOUBLE: {
                            dRes *= argValue.castAsDouble();
                            continue block43;
                        }
                        default: {
                            assert (false);
                            continue block43;
                        }
                    }
                }
                switch (resultType) {
                    case INTEGER: {
                        iRes /= argValue.castAsInt();
                        continue block43;
                    }
                    case LONG: {
                        lRes /= argValue.castAsLong();
                        continue block43;
                    }
                    case FLOAT: {
                        fRes /= argValue.castAsFloat();
                        continue block43;
                    }
                    case DOUBLE: {
                        dRes /= argValue.castAsDouble();
                        continue block43;
                    }
                    default: {
                        assert (false);
                        continue block43;
                    }
                }
            }
        }
        catch (ArithmeticException ae) {
            throw new QueryException("Arithmetic exception in query: " + ae.getMessage(), ae, this.getLocation());
        }
        FieldValueImpl res = null;
        switch (resultType) {
            case INTEGER: {
                res = FieldDefImpl.integerDef.createInteger(iRes);
                break;
            }
            case LONG: {
                res = FieldDefImpl.longDef.createLong(lRes);
                break;
            }
            case FLOAT: {
                res = FieldDefImpl.floatDef.createFloat(fRes);
                break;
            }
            case DOUBLE: {
                res = FieldDefImpl.doubleDef.createDouble(dRes);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        rcb.setRegVal(this.theResultReg, res);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter argIter : this.theArgs) {
            argIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter argIter : this.theArgs) {
            argIter.close(rcb);
        }
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i = 0;
        for (PlanIter argIter : this.theArgs) {
            formatter.indent(sb);
            if (this.theCode == FunctionLib.FuncCode.OP_ADD_SUB) {
                if (this.theOps.charAt(i) == '+') {
                    sb.append('+');
                } else {
                    sb.append('-');
                }
            } else if (this.theOps.charAt(i) == '*') {
                sb.append('*');
            } else {
                sb.append('/');
            }
            sb.append(",\n");
            argIter.display(sb, formatter);
            if (i < this.theArgs.length - 1) {
                sb.append(",\n");
            }
            ++i;
        }
    }
}

