/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.IndexAnalyzer;
import oracle.kv.table.Index;

class OptRulePushIndexPreds {
    private RuntimeException theException = null;
    private ArrayList<IndexAnalyzer> theAnalyzers;

    OptRulePushIndexPreds() {
    }

    RuntimeException getException() {
        return this.theException;
    }

    void apply(ExprSFW sfw) {
        try {
            boolean completePrimaryKey;
            Expr whereExpr = sfw.getWhereExpr();
            if (whereExpr == null && !sfw.hasSort()) {
                return;
            }
            TableImpl table = sfw.getTable();
            if (table == null) {
                return;
            }
            ExprBaseTable tableExpr = sfw.getTableExpr();
            ExprBaseTable.IndexHint forceIndexHint = tableExpr.getForceIndexHint();
            Map<String, Index> indexes = table.getIndexes();
            this.theAnalyzers = new ArrayList(1 + indexes.size());
            this.theAnalyzers.add(new IndexAnalyzer(sfw, table, null));
            IndexAnalyzer primaryAnalyzer = this.theAnalyzers.get(0);
            primaryAnalyzer.analyze();
            boolean bl = completePrimaryKey = primaryAnalyzer.thePrimaryKey != null && primaryAnalyzer.thePrimaryKey.isComplete();
            if (primaryAnalyzer.theSFW == null) {
                return;
            }
            if (forceIndexHint != null) {
                if (completePrimaryKey) {
                    sfw.removeSort();
                }
                if (sfw.hasSort() && sfw.getSortingIndex() != forceIndexHint.theIndex) {
                    String hintIndex = forceIndexHint.theIndex == null ? "primary" : forceIndexHint.theIndex.getName();
                    String sortingIndex = sfw.getSortingIndex() == null ? "primary" : sfw.getSortingIndex().getName();
                    throw new QueryException("Cannot perform order-by because the sorting index is not the same as the one forced via a hint.\nHint index    : " + hintIndex + "\n" + "Sorting index : " + sortingIndex, sfw.getLocation());
                }
                IndexAnalyzer analyzer = new IndexAnalyzer(sfw, table, forceIndexHint.theIndex);
                analyzer.analyze();
                if (analyzer.theSFW == null) {
                    return;
                }
                analyzer.apply();
                return;
            }
            if (completePrimaryKey) {
                primaryAnalyzer.apply();
                sfw.removeSort();
                return;
            }
            if (primaryAnalyzer.hasShardKey()) {
                if (sfw.hasSort() && sfw.getSortingIndex() != null) {
                    throw new QueryException("Cannot perform order-by because the query specifies a complete shard key, but the sorting index (" + sfw.getSortingIndex().getName() + ") is a secondary one.", sfw.getLocation());
                }
                primaryAnalyzer.apply();
                return;
            }
            if (sfw.hasSort()) {
                if (sfw.hasPrimaryIndexBasedSort()) {
                    primaryAnalyzer.apply();
                    return;
                }
                if (sfw.hasSecondaryIndexBasedSort()) {
                    IndexImpl index = sfw.getSortingIndex();
                    IndexAnalyzer analyzer = new IndexAnalyzer(sfw, table, index);
                    analyzer.analyze();
                    if (analyzer.theSFW != null) {
                        analyzer.apply();
                    }
                    return;
                }
            }
            boolean alwaysFalse = false;
            for (Map.Entry<String, Index> entry : indexes.entrySet()) {
                IndexImpl index = (IndexImpl)entry.getValue();
                IndexAnalyzer analyzer = new IndexAnalyzer(sfw, table, index);
                this.theAnalyzers.add(analyzer);
                analyzer.analyze();
                if (analyzer.theSFW != null) continue;
                alwaysFalse = true;
                break;
            }
            if (!alwaysFalse) {
                this.chooseIndex();
            }
        }
        catch (RuntimeException e) {
            this.theException = e;
        }
    }

    void chooseIndex() {
        IndexAnalyzer bestIndex = Collections.min(this.theAnalyzers);
        bestIndex.apply();
    }
}

