/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.NotIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.TypeManager;

class FuncNot
extends Function {
    FuncNot() {
        super(FunctionLib.FuncCode.OP_NOT, "NOT", TypeManager.BOOLEAN_QSTN(), TypeManager.BOOLEAN_ONE());
    }

    @Override
    public boolean mayReturnNULL(ExprFuncCall caller) {
        return caller.getArg(0).mayReturnNULL();
    }

    @Override
    Expr normalizeCall(ExprFuncCall notExpr) {
        ArrayList<Expr> newArgs;
        Function newFunc;
        FunctionLib lib = CompilerAPI.getFuncLib();
        Function argFunc = notExpr.getArg(0).getFunction(null);
        if (argFunc == null) {
            return notExpr;
        }
        ExprFuncCall arg = (ExprFuncCall)notExpr.getArg(0);
        FunctionLib.FuncCode argCode = argFunc.getCode();
        switch (argCode) {
            case OP_EXISTS: {
                newFunc = lib.getFunc(FunctionLib.FuncCode.OP_NOT_EXISTS);
                newArgs = new ArrayList(1);
                newArgs.add(arg.getInput());
                break;
            }
            case OP_NOT_EXISTS: {
                newFunc = lib.getFunc(FunctionLib.FuncCode.OP_EXISTS);
                newArgs = new ArrayList(1);
                newArgs.add(arg.getInput());
                break;
            }
            case OP_EQ: 
            case OP_NEQ: 
            case OP_GT: 
            case OP_GE: 
            case OP_LT: 
            case OP_LE: {
                newFunc = lib.getFunc(FuncCompOp.getNegationOp(argCode));
                newArgs = new ArrayList(2);
                newArgs.add(arg.getArg(0));
                newArgs.add(arg.getArg(1));
                break;
            }
            case OP_AND: 
            case OP_OR: {
                int numArgs = arg.getNumArgs();
                newArgs = new ArrayList<Expr>(numArgs);
                newFunc = lib.getFunc(argCode == FunctionLib.FuncCode.OP_OR ? FunctionLib.FuncCode.OP_AND : FunctionLib.FuncCode.OP_OR);
                for (int i = 0; i < numArgs; ++i) {
                    Expr newArg = ExprFuncCall.create(notExpr.getQCB(), notExpr.getSctx(), notExpr.getLocation(), (Function)this, arg.getArg(i));
                    newArgs.add(newArg);
                }
                break;
            }
            default: {
                return notExpr;
            }
        }
        Expr res = ExprFuncCall.create(notExpr.getQCB(), notExpr.getSctx(), notExpr.getLocation(), newFunc, newArgs);
        notExpr.replace(res, true);
        return res;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, Expr caller, PlanIter[] argIters) {
        assert (argIters.length == 1);
        int resultReg = codegen.allocateResultReg(caller);
        return new NotIter(caller, resultReg, this.theCode, argIters[0]);
    }
}

