/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.AnyOpIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;

public class FuncAnyOp
extends Function {
    FuncAnyOp(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.ANY_STAR(), TypeManager.ANY_STAR(), TypeManager.BOOLEAN_ONE());
    }

    @Override
    boolean isAnyComparison() {
        return true;
    }

    @Override
    public boolean mayReturnNULL(ExprFuncCall fncall) {
        return fncall.getArg(0).mayReturnNULL() || fncall.getArg(1).mayReturnNULL();
    }

    @Override
    Expr normalizeCall(ExprFuncCall fncall) {
        FieldDef.Type tc1;
        Expr op0 = fncall.getArg(0);
        Expr op1 = fncall.getArg(1);
        FieldDefImpl op0Def = op0.getType().getDef();
        FieldDefImpl op1Def = op1.getType().getDef();
        FieldDef.Type tc0 = op0Def.getType();
        if (tc0 == (tc1 = op1Def.getType())) {
            return fncall;
        }
        if (!TypeManager.areTypesComparable(op0.getType(), op1.getType())) {
            return new ExprConst(fncall.getQCB(), fncall.getSctx(), fncall.getLocation(), false);
        }
        return FuncCompOp.handleConstOperand(fncall, FuncAnyOp.anyToComp(this.theCode));
    }

    public static FunctionLib.FuncCode anyToComp(FunctionLib.FuncCode op) {
        switch (op) {
            case OP_GT_ANY: {
                return FunctionLib.FuncCode.OP_GT;
            }
            case OP_GE_ANY: {
                return FunctionLib.FuncCode.OP_GE;
            }
            case OP_LT_ANY: {
                return FunctionLib.FuncCode.OP_LT;
            }
            case OP_LE_ANY: {
                return FunctionLib.FuncCode.OP_LE;
            }
            case OP_EQ_ANY: {
                return FunctionLib.FuncCode.OP_EQ;
            }
            case OP_NEQ_ANY: {
                return FunctionLib.FuncCode.OP_NEQ;
            }
        }
        assert (false);
        return null;
    }

    static FunctionLib.FuncCode swapCompOp(FunctionLib.FuncCode op) {
        switch (op) {
            case OP_GT_ANY: {
                return FunctionLib.FuncCode.OP_LT_ANY;
            }
            case OP_GE_ANY: {
                return FunctionLib.FuncCode.OP_LE_ANY;
            }
            case OP_LT_ANY: {
                return FunctionLib.FuncCode.OP_GT_ANY;
            }
            case OP_LE_ANY: {
                return FunctionLib.FuncCode.OP_GE_ANY;
            }
        }
        return op;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, Expr fncall, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(fncall);
        return new AnyOpIter(fncall, resultReg, this.theCode, argIters);
    }
}

