/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprCase;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprIsOfType;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprReceive;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.ExprVisitor;

class ExprWalker {
    ExprVisitor theVisitor;
    boolean theAllocateChildrenIter;

    ExprWalker(ExprVisitor visitor, boolean allocateChildrenIter) {
        this.theVisitor = visitor;
        this.theAllocateChildrenIter = allocateChildrenIter;
    }

    void walk(Expr e) {
        switch (e.getKind()) {
            case CONST: {
                this.theVisitor.enter((ExprConst)e);
                this.theVisitor.exit((ExprConst)e);
                break;
            }
            case BASE_TABLE: {
                if (this.theVisitor.enter((ExprBaseTable)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprBaseTable)e);
                break;
            }
            case FUNC_CALL: {
                if (this.theVisitor.enter((ExprFuncCall)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprFuncCall)e);
                break;
            }
            case ARRAY_CONSTR: {
                if (this.theVisitor.enter((ExprArrayConstr)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprArrayConstr)e);
                break;
            }
            case MAP_CONSTR: {
                if (this.theVisitor.enter((ExprMapConstr)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprMapConstr)e);
                break;
            }
            case PROMOTE: {
                if (this.theVisitor.enter((ExprPromote)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprPromote)e);
                break;
            }
            case IS_OF_TYPE: {
                if (this.theVisitor.enter((ExprIsOfType)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprIsOfType)e);
                break;
            }
            case CAST: {
                if (this.theVisitor.enter((ExprCast)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprCast)e);
                break;
            }
            case FIELD_STEP: {
                if (this.theVisitor.enter((ExprFieldStep)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprFieldStep)e);
                break;
            }
            case MAP_FILTER: {
                if (this.theVisitor.enter((ExprMapFilter)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprMapFilter)e);
                break;
            }
            case ARRAY_FILTER: {
                if (this.theVisitor.enter((ExprArrayFilter)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprArrayFilter)e);
                break;
            }
            case ARRAY_SLICE: {
                if (this.theVisitor.enter((ExprArraySlice)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprArraySlice)e);
                break;
            }
            case CASE: {
                if (this.theVisitor.enter((ExprCase)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprCase)e);
                break;
            }
            case VAR: {
                this.theVisitor.enter((ExprVar)e);
                this.theVisitor.exit((ExprVar)e);
                break;
            }
            case SFW: {
                if (this.theVisitor.enter((ExprSFW)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprSFW)e);
                break;
            }
            case RECEIVE: {
                if (this.theVisitor.enter((ExprReceive)e)) {
                    this.walkChildren(e);
                }
                this.theVisitor.exit((ExprReceive)e);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void walkChildren(Expr e) {
        Expr.ExprIter children;
        Expr.ExprIter exprIter = children = this.theAllocateChildrenIter ? e.getChildrenIter() : e.getChildren();
        while (children.hasNext()) {
            Expr child = (Expr)children.next();
            this.walk(child);
        }
    }
}

