/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.List;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprIsOfType;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.runtime.CastIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.table.FieldDef;

class ExprUtils {
    ExprUtils() {
    }

    static void adjustConstructorTypes(Expr expr) {
        switch (expr.getKind()) {
            case ARRAY_CONSTR: {
                ExprArrayConstr arrExpr = (ExprArrayConstr)expr;
                ArrayDefImpl arrDef = arrExpr.getArrayType();
                if (!arrDef.getElement().equals(FieldDefImpl.jsonDef)) break;
                int numArgs = arrExpr.getNumArgs();
                for (int i = 0; i < numArgs; ++i) {
                    ExprUtils.constructJsonArrayMap(arrExpr.getArg(i));
                }
                break;
            }
            case MAP_CONSTR: {
                ExprMapConstr mapExpr = (ExprMapConstr)expr;
                MapDefImpl mapDef = mapExpr.getMapType();
                if (!mapDef.getElement().equals(FieldDefImpl.jsonDef)) break;
                int numArgs = mapExpr.getNumArgs();
                for (int i = 1; i < numArgs; i += 2) {
                    ExprUtils.constructJsonArrayMap(mapExpr.getArg(i));
                }
                break;
            }
            case SFW: {
                ExprSFW sfw = (ExprSFW)expr;
                int numFields = sfw.getNumFields();
                for (int i = 0; i < numFields; ++i) {
                    Expr fieldExpr = sfw.getFieldExpr(i);
                    FieldDefImpl fieldDef = fieldExpr.getType().getDef();
                    if (!fieldDef.equals(FieldDefImpl.jsonDef)) continue;
                    ExprUtils.constructJsonArrayMap(fieldExpr);
                }
                break;
            }
        }
        Expr.ExprIter children = expr.getChildren();
        while (children.hasNext()) {
            Expr child = (Expr)children.next();
            ExprUtils.adjustConstructorTypes(child);
        }
    }

    static void constructJsonArrayMap(Expr expr) {
        FieldDefImpl exprDef = expr.getType().getDef();
        if (exprDef.isAtomic() || exprDef.isRecord() || exprDef.isAnyRecord()) {
            return;
        }
        block0 : switch (expr.getKind()) {
            case ARRAY_CONSTR: {
                ExprArrayConstr arrExpr = (ExprArrayConstr)expr;
                ArrayDefImpl arrayDef = arrExpr.getArrayType();
                if (!arrayDef.getElement().isSubtype(FieldDefImpl.jsonDef)) break;
                arrExpr.setJsonArrayType();
                if (!arrExpr.computeType(false)) break;
                ExprUtils.propagateTypeChange(arrExpr);
                break;
            }
            case MAP_CONSTR: {
                ExprMapConstr mapExpr = (ExprMapConstr)expr;
                MapDefImpl mapDef = mapExpr.getMapType();
                if (!mapDef.getElement().isSubtype(FieldDefImpl.jsonDef)) break;
                mapExpr.setJsonMapType();
                if (!mapExpr.computeType(false)) break;
                ExprUtils.propagateTypeChange(mapExpr);
                break;
            }
            case VAR: {
                ExprVar var = (ExprVar)expr;
                if (var.isFor()) {
                    ExprUtils.constructJsonArrayMap(var.getDomainExpr());
                }
                return;
            }
            case SFW: {
                ExprSFW sfw = (ExprSFW)expr;
                int numFieldExprs = sfw.getNumFields();
                for (int i = 0; i < numFieldExprs; ++i) {
                    ExprUtils.constructJsonArrayMap(sfw.getFieldExpr(i));
                }
                return;
            }
            case ARRAY_SLICE: 
            case ARRAY_FILTER: 
            case MAP_FILTER: 
            case FIELD_STEP: {
                expr = expr.getInput();
                break;
            }
            case FUNC_CALL: {
                ExprFuncCall funcExpr = (ExprFuncCall)expr;
                switch (funcExpr.getFunction().getCode()) {
                    case OP_CONCAT: {
                        break block0;
                    }
                }
                return;
            }
            case PROMOTE: 
            case RECEIVE: 
            case CASE: {
                break;
            }
            case CONST: {
                ExprConst constExpr = (ExprConst)expr;
                FieldValueImpl val = constExpr.getValue();
                FieldDefImpl valDef = val.getDefinition();
                FieldValueImpl newVal = null;
                QueryException.Location loc = expr.getLocation();
                if (valDef.isArray() && !valDef.equals(FieldDefImpl.arrayJsonDef)) {
                    newVal = CastIter.castValue(val, FieldDefImpl.arrayJsonDef, loc);
                } else if (valDef.isMap() && !valDef.equals(FieldDefImpl.mapJsonDef)) {
                    newVal = CastIter.castValue(val, FieldDefImpl.mapJsonDef, loc);
                }
                if (newVal != null) {
                    ExprConst newExpr = new ExprConst(expr.getQCB(), expr.getSctx(), loc, newVal);
                    expr.replace(newExpr, true);
                }
                return;
            }
            case CAST: 
            case IS_OF_TYPE: 
            case BASE_TABLE: {
                return;
            }
            default: {
                throw new QueryStateException("Unexpected expression kind: " + (Object)((Object)expr.getKind()));
            }
        }
        Expr.ExprIter children = expr.getChildren();
        while (children.hasNext()) {
            Expr child = (Expr)children.next();
            ExprUtils.constructJsonArrayMap(child);
        }
    }

    static void propagateTypeChange(Expr expr) {
        int numParents = expr.getNumParents();
        for (int i = 0; i < numParents; ++i) {
            Expr parent = expr.getParent(i);
            switch (parent.getKind()) {
                case SFW: {
                    boolean modified;
                    ExprSFW sfw = (ExprSFW)parent;
                    ExprVar var = sfw.findVarForExpr(expr);
                    if (var == null || !(modified = var.computeType(false))) break;
                    ExprUtils.propagateTypeChange(var);
                    break;
                }
                case MAP_FILTER: {
                    ExprMapFilter mapFilter = (ExprMapFilter)parent;
                    ExprVar ctxVar = mapFilter.getCtxItemVar();
                    ExprVar elemVar = mapFilter.getCtxElemVar();
                    if (ctxVar != null && ctxVar.computeType(false)) {
                        ExprUtils.propagateTypeChange(ctxVar);
                    }
                    if (elemVar == null || !elemVar.computeType(false)) break;
                    ExprUtils.propagateTypeChange(elemVar);
                    break;
                }
                case ARRAY_FILTER: {
                    ExprArrayFilter arrFilter = (ExprArrayFilter)parent;
                    ExprVar ctxVar = arrFilter.getCtxItemVar();
                    ExprVar elemVar = arrFilter.getCtxElemVar();
                    if (ctxVar != null && ctxVar.computeType(false)) {
                        ExprUtils.propagateTypeChange(ctxVar);
                    }
                    if (elemVar == null || !elemVar.computeType(false)) break;
                    ExprUtils.propagateTypeChange(elemVar);
                    break;
                }
                case ARRAY_SLICE: {
                    ExprArraySlice arrSlice = (ExprArraySlice)parent;
                    ExprVar ctxVar = arrSlice.getCtxItemVar();
                    if (ctxVar == null || !ctxVar.computeType(false)) break;
                    ExprUtils.propagateTypeChange(ctxVar);
                    break;
                }
                case FIELD_STEP: {
                    ExprFieldStep fieldStep = (ExprFieldStep)parent;
                    ExprVar ctxVar = fieldStep.getCtxItemVar();
                    if (ctxVar == null || !ctxVar.computeType(false)) break;
                    ExprUtils.propagateTypeChange(ctxVar);
                    break;
                }
            }
            boolean modified = parent.computeType(false);
            if (!modified) continue;
            ExprUtils.propagateTypeChange(parent);
        }
    }

    static boolean matchExprs(Expr expr1, Expr expr2) {
        if (expr1.getKind() != expr2.getKind()) {
            return false;
        }
        if (expr1.getNumChildren() != expr2.getNumChildren()) {
            return false;
        }
        switch (expr1.getKind()) {
            case CONST: {
                ExprConst e1 = (ExprConst)expr1;
                ExprConst e2 = (ExprConst)expr2;
                return e1.getValue().equals(e2.getValue());
            }
            case BASE_TABLE: {
                ExprBaseTable e1 = (ExprBaseTable)expr1;
                ExprBaseTable e2 = (ExprBaseTable)expr2;
                assert (e1 == e2);
                return true;
            }
            case VAR: {
                ExprVar e1 = (ExprVar)expr1;
                ExprVar e2 = (ExprVar)expr2;
                if (e1.getVarKind() != e2.getVarKind()) {
                    return false;
                }
                if (e1.getVarKind() == ExprVar.VarKind.EXTERNAL) {
                    return e1.getId() == e2.getId();
                }
                if (e1.isContext()) {
                    return ExprUtils.matchExprs(e1.getCtxExpr(), e2.getCtxExpr());
                }
                return ExprUtils.matchExprs(e1.getDomainExpr(), e2.getDomainExpr());
            }
            case FUNC_CALL: {
                ExprFuncCall e1 = (ExprFuncCall)expr1;
                ExprFuncCall e2 = (ExprFuncCall)expr2;
                if (e1.getFunction() != e2.getFunction()) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2);
            }
            case PROMOTE: {
                ExprPromote e1 = (ExprPromote)expr1;
                ExprPromote e2 = (ExprPromote)expr2;
                return e1.getTargetType().equals(e2.getTargetType()) && ExprUtils.matchExprs(e1.getInput(), e2.getInput());
            }
            case IS_OF_TYPE: {
                ExprIsOfType e1 = (ExprIsOfType)expr1;
                ExprIsOfType e2 = (ExprIsOfType)expr2;
                if (e1.isNot() != e2.isNot()) {
                    return false;
                }
                List<FieldDef> types1 = e1.getTargetTypes();
                List<FieldDef> types2 = e2.getTargetTypes();
                List<ExprType.Quantifier> quants1 = e1.getTargetQuantifiers();
                List<ExprType.Quantifier> quants2 = e2.getTargetQuantifiers();
                List<Boolean> onlyflags1 = e1.getOnlyTargetFlags();
                List<Boolean> onlyflags2 = e2.getOnlyTargetFlags();
                if (types1.size() != types2.size()) {
                    return false;
                }
                for (int i = 0; i < types1.size(); ++i) {
                    if (quants1.get(i) == quants2.get(i) && onlyflags1.get(i) == onlyflags2.get(i) && types1.get(i).equals(types2.get(i))) continue;
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2);
            }
            case CAST: {
                ExprCast e1 = (ExprCast)expr1;
                ExprCast e2 = (ExprCast)expr2;
                if (e1.getTargetQuantifier() != e2.getTargetQuantifier() || !e1.getTargetType().equals(e2.getTargetType())) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2);
            }
            case FIELD_STEP: {
                ExprFieldStep e1 = (ExprFieldStep)expr1;
                ExprFieldStep e2 = (ExprFieldStep)expr2;
                if (e1.isConst() != e2.isConst()) {
                    return false;
                }
                if (e1.isConst()) {
                    return e1.getFieldName().equals(e2.getFieldName());
                }
                return ExprUtils.matchChildren(e1, e2);
            }
            case MAP_FILTER: {
                ExprMapFilter e1 = (ExprMapFilter)expr1;
                ExprMapFilter e2 = (ExprMapFilter)expr2;
                if (e1.isConst() != e2.isConst()) {
                    return false;
                }
                if (e1.isConst()) {
                    return e1.getConstValue() == e2.getConstValue();
                }
                return ExprUtils.matchChildren(e1, e2);
            }
            case ARRAY_FILTER: {
                ExprArrayFilter e1 = (ExprArrayFilter)expr1;
                ExprArrayFilter e2 = (ExprArrayFilter)expr2;
                if (e1.isConst() != e2.isConst()) {
                    return false;
                }
                if (e1.isConst()) {
                    return e1.getConstValue().equals(e2.getConstValue());
                }
                return ExprUtils.matchChildren(e1, e2);
            }
            case ARRAY_SLICE: {
                ExprArraySlice e1 = (ExprArraySlice)expr1;
                ExprArraySlice e2 = (ExprArraySlice)expr2;
                if (e1.getLowValue() != null ? !e1.getLowValue().equals(e2.getLowValue()) : e2.getLowValue() != null) {
                    return false;
                }
                if (e1.getHighValue() != null ? !e1.getHighValue().equals(e2.getHighValue()) : e2.getHighValue() != null) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2);
            }
            case CASE: {
                return ExprUtils.matchChildren(expr1, expr2);
            }
            case ARRAY_CONSTR: {
                return ExprUtils.matchChildren(expr1, expr2);
            }
            case MAP_CONSTR: {
                ExprMapConstr map1 = (ExprMapConstr)expr1;
                ExprMapConstr map2 = (ExprMapConstr)expr2;
                if (map1.theArgs.size() != map2.theArgs.size()) {
                    return false;
                }
                int numArgs = map1.theArgs.size();
                boolean[] matched = new boolean[numArgs];
                for (int i = 0; i < numArgs; ++i) {
                    int j;
                    for (j = 0; j < numArgs; ++j) {
                        if (i % 2 != j % 2 || matched[j] || !ExprUtils.matchExprs(map1.theArgs.get(i), map2.theArgs.get(j))) continue;
                        matched[j] = true;
                        break;
                    }
                    if (j != numArgs) continue;
                    return false;
                }
                return true;
            }
            case SFW: {
                return ExprUtils.matchChildren(expr1, expr2);
            }
        }
        throw new QueryStateException("Unexprected expression kind : " + (Object)((Object)expr1.getKind()));
    }

    private static boolean matchChildren(Expr expr1, Expr expr2) {
        Expr.ExprIter children1 = expr1.getChildren();
        Expr.ExprIter children2 = expr2.getChildren();
        while (children1.hasNext()) {
            Expr child2;
            assert (children2.hasNext());
            Expr child1 = children1.next();
            if (ExprUtils.matchExprs(child1, child2 = children2.next())) continue;
            return false;
        }
        return true;
    }

    static boolean isPrimKeyColumnRef(TableImpl table, int pkColPos, Expr expr) {
        if (expr.getKind() != Expr.ExprKind.FIELD_STEP) {
            return false;
        }
        ExprFieldStep stepExpr = (ExprFieldStep)expr;
        int fieldPos = stepExpr.getFieldPos();
        if (fieldPos != pkColPos) {
            return false;
        }
        if (stepExpr.getInput().getKind() != Expr.ExprKind.VAR) {
            return false;
        }
        TableImpl table2 = ((ExprVar)stepExpr.getInput()).getTable();
        return table2 != null && table2 == table;
    }

    static boolean isIndexColumnRef(TableImpl table, TablePath ipath, Expr expr, TablePath epath) {
        block5: while (true) {
            switch (expr.getKind()) {
                case FIELD_STEP: {
                    ExprFieldStep stepExpr = (ExprFieldStep)expr;
                    String fieldName = stepExpr.getFieldName();
                    if (fieldName == null) {
                        return false;
                    }
                    epath.add(fieldName);
                    if (stepExpr.getInput().getType().isArray()) {
                        return false;
                    }
                    expr = expr.getInput();
                    continue block5;
                }
                case VAR: {
                    ExprVar var = (ExprVar)expr;
                    if (var.isFor()) {
                        return ExprUtils.isIndexColumnRef(table, ipath, var.getDomainExpr(), epath);
                    }
                    return false;
                }
                case BASE_TABLE: {
                    ExprBaseTable tableExpr = (ExprBaseTable)expr;
                    if (tableExpr.getTable() == table) {
                        epath.reverseSteps();
                        return ipath.equals(epath);
                    }
                    return false;
                }
            }
            break;
        }
        return false;
    }
}

