/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;

class ExprFuncCall
extends Expr {
    private final ArrayList<Expr> theArgs;
    private final Function theFunction;

    static Expr create(QueryControlBlock qcb, StaticContext sctx, QueryException.Location loc, Function func, Expr arg) {
        ArrayList<Expr> args = new ArrayList<Expr>(1);
        args.add(arg);
        return ExprFuncCall.create(qcb, sctx, loc, func, args);
    }

    static Expr create(QueryControlBlock qcb, StaticContext sctx, QueryException.Location loc, Function func, ArrayList<Expr> args) {
        int numArgs = args.size();
        for (int i = 0; i < numArgs; ++i) {
            Expr arg = args.get(i);
            ExprType paramType = func.getParamType(i);
            arg = ExprPromote.create(null, arg, paramType);
            args.set(i, arg);
        }
        ExprFuncCall fncall = new ExprFuncCall(qcb, sctx, loc, func, args);
        return func.normalizeCall(fncall);
    }

    private ExprFuncCall(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, Function f, ArrayList<Expr> args) {
        super(qcb, sctx, Expr.ExprKind.FUNC_CALL, location);
        this.theFunction = f;
        this.theArgs = args;
        for (Expr arg : args) {
            arg.addParent(this);
        }
    }

    @Override
    int getNumChildren() {
        return this.theArgs.size();
    }

    int getNumArgs() {
        return this.theArgs.size();
    }

    ArrayList<Expr> getArgs() {
        return this.theArgs;
    }

    @Override
    Expr getInput() {
        if (this.getNumArgs() != 1) {
            throw new ClassCastException("Expression does not have a single input: " + this.getClass());
        }
        return this.getArg(0);
    }

    Expr getArg(int i) {
        return this.theArgs.get(i);
    }

    void setArg(int i, Expr newExpr, boolean destroy) {
        this.theArgs.get(i).removeParent(this, destroy);
        this.theArgs.set(i, newExpr);
        newExpr.addParent(this);
    }

    void removeArg(int i, boolean destroy) {
        if (!this.theFunction.isVariadic()) {
            throw new QueryStateException("Cannot remove argument from a non-variadic function");
        }
        this.theArgs.get(i).removeParent(this, destroy);
        this.theArgs.remove(i);
    }

    void setArgInternal(int i, Expr arg) {
        this.theArgs.set(i, arg);
    }

    Function getFunction() {
        return this.theFunction;
    }

    @Override
    ExprType computeType() {
        return this.theFunction.getRetType(this);
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theFunction.mayReturnNULL(this);
    }

    @Override
    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append(this.theFunction.getName());
        sb.append("\n");
        formatter.indent(sb);
        sb.append("[\n");
        formatter.incIndent();
        this.displayContent(sb, formatter);
        formatter.decIndent();
        sb.append("\n");
        formatter.indent(sb);
        sb.append("]");
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 0; i < this.theArgs.size(); ++i) {
            this.theArgs.get(i).display(sb, formatter);
            if (i >= this.theArgs.size() - 1) continue;
            sb.append(",\n");
        }
    }
}

