/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldRange;

class ExprBaseTable
extends Expr {
    private final TableImpl theTable;
    private Direction theDirection = Direction.FORWARD;
    private PrimaryKeyImpl thePrimaryKey;
    private IndexKeyImpl theSecondaryKey;
    private FieldRange theRange;
    private Expr theFilteringPred;
    private boolean theUsesCoveringIndex;
    private ArrayList<Expr> thePushedExternals;
    private List<IndexHint> theIndexHints = null;
    private IndexHint theForceIndexHint = null;
    private boolean theEliminateIndexDups;

    ExprBaseTable(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, TableImpl table) {
        super(qcb, sctx, Expr.ExprKind.BASE_TABLE, location);
        this.theTable = table;
        ExprType exprType = TypeManager.createTableRecordType(table, ExprType.Quantifier.STAR);
        this.setType(exprType);
    }

    TableImpl getTable() {
        return this.theTable;
    }

    @Override
    int getNumChildren() {
        return this.theFilteringPred != null ? 1 : 0;
    }

    Direction getDirection() {
        return this.theDirection;
    }

    void setDirection(Direction dir) {
        this.theDirection = dir;
    }

    PrimaryKeyImpl getPrimaryKey() {
        return this.thePrimaryKey;
    }

    void addPrimaryKey(PrimaryKeyImpl key, boolean isCoveringIndex) {
        this.thePrimaryKey = key;
        this.theUsesCoveringIndex = isCoveringIndex;
    }

    IndexKeyImpl getSecondaryKey() {
        return this.theSecondaryKey;
    }

    void addSecondaryKey(IndexKeyImpl key, boolean isCoveringIndex) {
        this.theSecondaryKey = key;
        this.theUsesCoveringIndex = isCoveringIndex;
    }

    FieldRange getRange() {
        return this.theRange;
    }

    void addRange(FieldRange range) {
        this.theRange = range;
    }

    Expr getFilteringPred() {
        return this.theFilteringPred;
    }

    void setFilteringPred(Expr pred, boolean destroy) {
        if (this.theFilteringPred != null) {
            this.theFilteringPred.removeParent(this, destroy);
        }
        this.theFilteringPred = pred = ExprPromote.create(null, pred, TypeManager.BOOLEAN_QSTN());
        this.theFilteringPred.addParent(this);
    }

    void removeFilteringPred(boolean destroy) {
        this.theFilteringPred.removeParent(this, destroy);
        this.theFilteringPred = null;
    }

    boolean getUsesCoveringIndex() {
        return this.theUsesCoveringIndex;
    }

    void setPushedExternals(ArrayList<Expr> v) {
        assert (this.thePushedExternals == null);
        this.thePushedExternals = v;
    }

    ArrayList<Expr> getPushedExternals() {
        return this.thePushedExternals;
    }

    boolean isIndexHint(IndexImpl index) {
        if (this.theIndexHints == null) {
            return false;
        }
        for (IndexHint hint : this.theIndexHints) {
            if (hint.theIndex != index) continue;
            return true;
        }
        return false;
    }

    IndexHint getForceIndexHint() {
        return this.theForceIndexHint;
    }

    void addIndexHint(IndexImpl index, boolean force, QueryException.Location loc) {
        IndexHint hint;
        if (this.theIndexHints == null) {
            this.theIndexHints = new ArrayList<IndexHint>();
        }
        if (!ExprBaseTable.containsHint(this.theIndexHints, hint = new IndexHint(index, force))) {
            this.theIndexHints.add(hint);
        }
        if (force) {
            if (this.theForceIndexHint != null) {
                throw new QueryException("Cannot have more than one FORCE_INDEX hints", loc);
            }
            this.theForceIndexHint = hint;
        }
    }

    private static boolean containsHint(List<IndexHint> indexHints, IndexHint hint) {
        for (IndexHint h : indexHints) {
            if (!h.theIndex.getName().equals(hint.theIndex.getName())) continue;
            return true;
        }
        return false;
    }

    void setEliminateIndexDups() {
        this.theEliminateIndexDups = true;
    }

    boolean getEliminateIndexDups() {
        return this.theEliminateIndexDups;
    }

    @Override
    ExprType computeType() {
        return this.getTypeInternal();
    }

    @Override
    public boolean mayReturnNULL() {
        return false;
    }

    @Override
    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("TABLE");
        this.displayContent(sb, formatter);
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        if (this.thePrimaryKey != null || this.theRange != null) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("[\n");
            formatter.incIndent();
            formatter.indent(sb);
            sb.append(this.theTable.getName());
            if (this.thePrimaryKey != null) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append("KEY: ");
                sb.append(this.thePrimaryKey);
            }
            if (this.theRange != null) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append("RANGE: ");
                sb.append(this.theRange);
            }
            if (this.thePushedExternals != null) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append("PUSHED EXTERNAL EXPRS: ");
                for (Expr expr : this.thePushedExternals) {
                    sb.append("\n");
                    if (expr == null) {
                        formatter.indent(sb);
                        sb.append("null");
                        continue;
                    }
                    expr.display(sb, formatter);
                }
            }
            formatter.decIndent();
            sb.append("\n");
            formatter.indent(sb);
            sb.append("]");
        } else {
            sb.append("[");
            sb.append(this.theTable.getName());
            sb.append("]");
        }
    }

    static class IndexHint {
        IndexImpl theIndex;
        boolean theForce;

        IndexHint(IndexImpl index, boolean force) {
            this.theIndex = index;
            this.theForce = force;
        }
    }
}

