/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.impl.api.query.PreparedDdlStatementImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.DdlException;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StatementFactory;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.query.PreparedStatement;

public class CompilerAPI {
    static StaticContext theRootSctx = new StaticContext(null);
    static FunctionLib theFunctionLib = new FunctionLib(theRootSctx);

    static FunctionLib getFuncLib() {
        return theFunctionLib;
    }

    public static PreparedStatement prepare(TableAPIImpl tableAPI, String queryString) {
        try {
            StaticContext querySctx = new StaticContext(theRootSctx);
            QueryControlBlock qcb = new QueryControlBlock(tableAPI, queryString, querySctx);
            qcb.compile();
            if (qcb.succeeded()) {
                return new PreparedStatementImpl(qcb.getQueryPlan(), qcb.getResultDef(), qcb.getNumRegs(), qcb.getNumIterators(), qcb.getInitSctx().getExternalVars(), qcb);
            }
            if (qcb.getException() instanceof QueryStateException) {
                Logger logger = tableAPI.getStore().getLogger();
                if (logger != null) {
                    logger.warning(qcb.getException().toString());
                }
                throw qcb.getException();
            }
            if (qcb.getException() instanceof FaultException) {
                throw qcb.getException();
            }
            if (qcb.getException() instanceof QueryException) {
                throw qcb.getException();
            }
            throw new IllegalArgumentException(qcb.getErrorMessage());
        }
        catch (DdlException ddle) {
            return new PreparedDdlStatementImpl(queryString);
        }
    }

    public static QueryControlBlock compile(String queryString, TableMetadata metadata, StatementFactory statementFactory) {
        StaticContext querySctx = new StaticContext(theRootSctx);
        QueryControlBlock qcb = new QueryControlBlock(metadata, statementFactory, queryString, querySctx);
        qcb.compile();
        return qcb;
    }

    public static QueryControlBlock parse(String queryString, TableMetadata meta) {
        StaticContext initSctx = new StaticContext(theRootSctx);
        QueryControlBlock qcb = new QueryControlBlock(meta, null, queryString, initSctx);
        qcb.parse();
        return qcb;
    }
}

