/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprCase;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprIsOfType;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprReceive;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprUtils;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.ExprVisitor;
import oracle.kv.impl.query.compiler.ExprWalker;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.runtime.ArrayConstrIter;
import oracle.kv.impl.query.runtime.ArrayFilterIter;
import oracle.kv.impl.query.runtime.ArraySliceIter;
import oracle.kv.impl.query.runtime.BaseTableIter;
import oracle.kv.impl.query.runtime.CaseIter;
import oracle.kv.impl.query.runtime.CastIter;
import oracle.kv.impl.query.runtime.ConcatIter;
import oracle.kv.impl.query.runtime.ConstIter;
import oracle.kv.impl.query.runtime.ExternalVarRefIter;
import oracle.kv.impl.query.runtime.FieldStepIter;
import oracle.kv.impl.query.runtime.IsOfTypeIter;
import oracle.kv.impl.query.runtime.MapConstrIter;
import oracle.kv.impl.query.runtime.MapFilterIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PromoteIter;
import oracle.kv.impl.query.runtime.ReceiveIter;
import oracle.kv.impl.query.runtime.SFWIter;
import oracle.kv.impl.query.runtime.VarRefIter;

public class CodeGenerator
extends ExprVisitor {
    private final QueryControlBlock theQCB;
    private final ExprWalker theWalker;
    private final HashMap<Expr, Integer> theResultRegsMap;
    private final HashMap<Expr, int[]> theTupleRegsMap;
    private final Stack<PlanIter> theIters;
    private PlanIter theRootIter;
    private RuntimeException theException = null;

    CodeGenerator(QueryControlBlock qcb) {
        this.theQCB = qcb;
        this.theWalker = new ExprWalker(this, false);
        this.theResultRegsMap = new HashMap();
        this.theTupleRegsMap = new HashMap();
        this.theIters = new Stack();
    }

    public RuntimeException getException() {
        return this.theException;
    }

    public void setException(RuntimeException e) {
        this.theException = e;
    }

    PlanIter getRootIter() {
        return this.theRootIter;
    }

    public void generatePlan(Expr expr) {
        try {
            if (this.theQCB.theHaveJsonConstructors) {
                ExprUtils.adjustConstructorTypes(expr);
            }
            this.theWalker.walk(expr);
            this.theRootIter = this.theIters.pop();
            assert (this.theIters.isEmpty());
        }
        catch (RuntimeException e) {
            this.setException(e);
        }
    }

    int allocateResultReg(Expr e) {
        Integer reg = this.theResultRegsMap.get(e);
        if (reg == null) {
            reg = new Integer(this.theQCB.getNumRegs());
            this.theResultRegsMap.put(e, reg);
            this.theQCB.incNumRegs(1);
        }
        return reg;
    }

    int allocateLocalReg() {
        Integer reg = new Integer(this.theQCB.getNumRegs());
        this.theQCB.incNumRegs(1);
        return reg;
    }

    void setResultReg(Expr e, int reg) {
        assert (reg >= 0 && reg < this.theQCB.getNumRegs());
        Integer currReg = this.theResultRegsMap.get(e);
        if (currReg != null) {
            throw new QueryStateException("Cannot update existing register for expression: " + e.display());
        }
        currReg = new Integer(reg);
        this.theResultRegsMap.put(e, currReg);
    }

    int getResultReg(Expr e) {
        Integer reg = this.theResultRegsMap.get(e);
        return reg == null ? -1 : reg;
    }

    int[] allocateTupleRegs(Expr e, int numRegs) {
        int[] regs = this.theTupleRegsMap.get(e);
        if (regs == null) {
            regs = new int[numRegs];
            this.theTupleRegsMap.put(e, regs);
            for (int i = 0; i < numRegs; ++i) {
                regs[i] = this.theQCB.getNumRegs() + i;
            }
            this.theQCB.incNumRegs(numRegs);
        }
        return regs;
    }

    void setTupleRegs(Expr e, int[] regs) {
        if (regs == null) {
            return;
        }
        int[] currRegs = this.theTupleRegsMap.get(e);
        if (currRegs != null) {
            throw new QueryStateException("Cannot update existing tuple registers for expression: " + e.display());
        }
        this.theTupleRegsMap.put(e, regs);
    }

    int[] getTupleRegs(Expr e) {
        return this.theTupleRegsMap.get(e);
    }

    @Override
    void exit(ExprReceive e) {
        PlanIter inputIter = this.theIters.pop();
        int resultReg = inputIter.getResultReg();
        PlanIter[] pushedExternalIters = null;
        if (e.getPushedExternals() != null) {
            ArrayList<Expr> pushedExternalExprs = e.getPushedExternals();
            int size = pushedExternalExprs.size();
            pushedExternalIters = new PlanIter[size];
            for (int i = 0; i < size; ++i) {
                PlanIter iter;
                Expr expr = pushedExternalExprs.get(i);
                if (expr == null) {
                    pushedExternalIters[i] = null;
                    continue;
                }
                this.theWalker.walk(expr);
                pushedExternalIters[i] = iter = this.theIters.pop();
            }
        }
        int[] tupleRegs = null;
        if (inputIter.producesTuples() && this.theQCB.getRootExpr() != e) {
            tupleRegs = inputIter.getTupleRegs();
        }
        this.theQCB.setPushedDistributionKind(e.getDistributionKind());
        ReceiveIter iter = new ReceiveIter(e, resultReg, tupleRegs, inputIter, e.getType().getDef(), e.mayReturnNULL(), e.getSortFieldPositions(), e.getSortSpecs(), e.getPrimKeyPositions(), e.getDistributionKind(), e.getPrimaryKey(), pushedExternalIters, this.theQCB.getNumRegs(), this.theQCB.getNumIterators());
        this.theIters.push(iter);
    }

    @Override
    void exit(ExprConst e) {
        int resultReg = this.allocateResultReg(e);
        ConstIter constIter = new ConstIter(e, resultReg, e.getValue());
        this.theIters.push(constIter);
    }

    @Override
    void exit(ExprVar e) {
        PlanIter varIter;
        String name = e.getName();
        if (e.isExternal()) {
            int resultReg = this.allocateResultReg(e);
            varIter = new ExternalVarRefIter(e, resultReg, e.getId(), name);
        } else {
            int resultReg = this.getResultReg(e);
            int[] inputTupleRegs = this.getTupleRegs(e);
            varIter = new VarRefIter(e, resultReg, inputTupleRegs, name);
        }
        this.theIters.push(varIter);
    }

    @Override
    void exit(ExprArrayConstr e) {
        int numArgs = e.getNumArgs();
        PlanIter[] argIters = new PlanIter[numArgs];
        for (int i = 0; i < e.getNumArgs(); ++i) {
            argIters[numArgs - i - 1] = this.theIters.pop();
        }
        int resultReg = this.allocateResultReg(e);
        ArrayConstrIter iter = new ArrayConstrIter(e, resultReg, argIters);
        this.theIters.push(iter);
    }

    @Override
    void exit(ExprMapConstr e) {
        int numArgs = e.getNumArgs();
        PlanIter[] argIters = new PlanIter[numArgs];
        for (int i = 0; i < e.getNumArgs(); ++i) {
            argIters[numArgs - i - 1] = this.theIters.pop();
        }
        int resultReg = this.allocateResultReg(e);
        MapConstrIter iter = new MapConstrIter(e, resultReg, argIters);
        this.theIters.push(iter);
    }

    @Override
    void exit(ExprFuncCall e) {
        int numArgs = e.getNumArgs();
        PlanIter[] argIters = new PlanIter[numArgs];
        for (int i = 0; i < e.getNumArgs(); ++i) {
            argIters[numArgs - i - 1] = this.theIters.pop();
        }
        PlanIter iter = e.getFunction().codegen(this, e, argIters);
        this.theIters.push(iter);
    }

    @Override
    void exit(ExprPromote e) {
        PlanIter inputIter = this.theIters.pop();
        int resultReg = inputIter.producesTuples() ? inputIter.getResultReg() : this.allocateResultReg(e);
        PromoteIter promoteIter = new PromoteIter(e, resultReg, inputIter, e.getTargetType());
        this.theIters.push(promoteIter);
    }

    @Override
    void exit(ExprIsOfType e) {
        PlanIter inputIter = this.theIters.pop();
        int resultReg = this.allocateResultReg(e);
        IsOfTypeIter isOfTypeIter = new IsOfTypeIter(e, resultReg, inputIter, e.isNot(), e.getTargetTypes(), e.getTargetQuantifiers(), e.getOnlyTargetFlags());
        this.theIters.push(isOfTypeIter);
    }

    @Override
    void exit(ExprCast e) {
        PlanIter inputIter = this.theIters.pop();
        int resultReg = this.allocateResultReg(e);
        CastIter castIter = new CastIter(e, resultReg, inputIter, e.getTargetType(), e.getTargetQuantifier());
        this.theIters.push(castIter);
    }

    @Override
    boolean enter(ExprFieldStep e) {
        ExprVar ctxItemVar = e.getCtxItemVar();
        if (ctxItemVar != null) {
            this.allocateResultReg(ctxItemVar);
        }
        return true;
    }

    @Override
    void exit(ExprFieldStep e) {
        int resultReg;
        PlanIter inputIter;
        PlanIter fieldNameIter = null;
        int ctxItemReg = -1;
        if (!e.isConst()) {
            fieldNameIter = this.theIters.pop();
            inputIter = this.theIters.pop();
            ExprVar ctxItemVar = e.getCtxItemVar();
            ctxItemReg = ctxItemVar != null ? this.getResultReg(ctxItemVar) : -1;
            resultReg = this.allocateResultReg(e);
        } else {
            inputIter = this.theIters.pop();
            if (inputIter.producesTuples()) {
                int[] inputTupleRegs = inputIter.getTupleRegs();
                resultReg = inputTupleRegs[e.getFieldPos()];
            } else {
                resultReg = this.allocateResultReg(e);
            }
        }
        FieldStepIter iter = new FieldStepIter(e, resultReg, inputIter, fieldNameIter, e.getFieldName(), e.getFieldPos(), ctxItemReg);
        this.theIters.push(iter);
    }

    @Override
    boolean enter(ExprMapFilter e) {
        if (e.getType().isEmpty()) {
            assert (e.isConst());
            PlanIter[] argIters = new PlanIter[]{};
            int resultReg = this.allocateResultReg(e);
            ConcatIter iter = new ConcatIter(e, resultReg, argIters);
            this.theIters.push(iter);
            return false;
        }
        ExprVar ctxItemVar = e.getCtxItemVar();
        ExprVar ctxElemVar = e.getCtxElemVar();
        ExprVar ctxKeyVar = e.getCtxKeyVar();
        if (ctxItemVar != null) {
            this.allocateResultReg(ctxItemVar);
        }
        if (ctxElemVar != null) {
            this.allocateResultReg(ctxElemVar);
        }
        if (ctxKeyVar != null) {
            this.allocateResultReg(ctxKeyVar);
        }
        return true;
    }

    @Override
    void exit(ExprMapFilter e) {
        if (e.getType().isEmpty()) {
            return;
        }
        assert (e.isConst() || e.getConstValue());
        PlanIter predIter = e.getPredExpr() != null ? this.theIters.pop() : null;
        PlanIter inputIter = this.theIters.pop();
        ExprVar ctxItemVar = e.getCtxItemVar();
        int ctxItemReg = ctxItemVar != null ? this.getResultReg(ctxItemVar) : -1;
        ExprVar ctxElemVar = e.getCtxElemVar();
        int ctxElemReg = ctxElemVar != null ? this.getResultReg(ctxElemVar) : -1;
        ExprVar ctxKeyVar = e.getCtxKeyVar();
        int ctxKeyReg = ctxKeyVar != null ? this.getResultReg(ctxKeyVar) : -1;
        int resultReg = this.allocateResultReg(e);
        MapFilterIter iter = new MapFilterIter(e, resultReg, inputIter, predIter, ctxItemReg, ctxElemReg, ctxKeyReg);
        this.theIters.push(iter);
    }

    @Override
    boolean enter(ExprArraySlice e) {
        ExprVar ctxItemVar = e.getCtxItemVar();
        if (ctxItemVar != null) {
            this.allocateResultReg(ctxItemVar);
        }
        return true;
    }

    @Override
    void exit(ExprArraySlice e) {
        PlanIter inputIter;
        PlanIter lowIter = null;
        PlanIter highIter = null;
        int ctxItemReg = -1;
        if (!e.isConst()) {
            highIter = e.getHighExpr() != null ? this.theIters.pop() : null;
            lowIter = e.getLowExpr() != null ? this.theIters.pop() : null;
            inputIter = this.theIters.pop();
            ExprVar ctxItemVar = e.getCtxItemVar();
            ctxItemReg = ctxItemVar != null ? this.getResultReg(ctxItemVar) : -1;
        } else {
            inputIter = this.theIters.pop();
        }
        int resultReg = this.allocateResultReg(e);
        ArraySliceIter iter = new ArraySliceIter(e, resultReg, inputIter, lowIter, highIter, e.getLowValue(), e.getHighValue(), ctxItemReg);
        this.theIters.push(iter);
    }

    @Override
    boolean enter(ExprArrayFilter e) {
        if (e.getType().isEmpty()) {
            assert (e.isConst());
            PlanIter[] argIters = new PlanIter[]{};
            int resultReg = this.allocateResultReg(e);
            ConcatIter iter = new ConcatIter(e, resultReg, argIters);
            this.theIters.push(iter);
            return false;
        }
        ExprVar ctxItemVar = e.getCtxItemVar();
        ExprVar ctxElemVar = e.getCtxElemVar();
        ExprVar ctxElemPosVar = e.getCtxElemPosVar();
        if (ctxItemVar != null) {
            this.allocateResultReg(ctxItemVar);
        }
        if (ctxElemVar != null) {
            this.allocateResultReg(ctxElemVar);
        }
        if (ctxElemPosVar != null) {
            this.allocateResultReg(ctxElemPosVar);
        }
        return true;
    }

    @Override
    void exit(ExprArrayFilter e) {
        PlanIter predIter = e.getPredExpr() != null ? this.theIters.pop() : null;
        PlanIter inputIter = this.theIters.pop();
        ExprVar ctxItemVar = e.getCtxItemVar();
        int ctxItemReg = ctxItemVar != null ? this.getResultReg(ctxItemVar) : -1;
        ExprVar ctxElemVar = e.getCtxElemVar();
        int ctxElemReg = ctxElemVar != null ? this.getResultReg(ctxElemVar) : -1;
        ExprVar ctxElemPosVar = e.getCtxElemPosVar();
        int ctxElemPosReg = ctxElemPosVar != null ? this.getResultReg(ctxElemPosVar) : -1;
        int resultReg = this.allocateResultReg(e);
        ArrayFilterIter iter = new ArrayFilterIter(e, resultReg, inputIter, predIter, ctxItemReg, ctxElemReg, ctxElemPosReg);
        this.theIters.push(iter);
    }

    @Override
    void exit(ExprCase e) {
        PlanIter elseIter = null;
        if (e.hasElseClause()) {
            elseIter = this.theIters.pop();
        }
        PlanIter[] condIters = new PlanIter[e.getNumWhenClauses()];
        PlanIter[] thenIters = new PlanIter[e.getNumWhenClauses()];
        int numWhenClauses = e.getNumWhenClauses();
        for (int i = numWhenClauses - 1; i >= 0; --i) {
            thenIters[i] = this.theIters.pop();
            condIters[i] = this.theIters.pop();
        }
        int resultReg = this.allocateResultReg(e);
        CaseIter iter = new CaseIter(e, resultReg, condIters, thenIters, elseIter);
        this.theIters.push(iter);
    }

    @Override
    boolean enter(ExprBaseTable e) {
        int numTupleRegs = ((RecordDefImpl)e.getType().getDef()).getNumFields();
        int[] tupleRegs = this.allocateTupleRegs(e, numTupleRegs);
        int resultReg = this.allocateResultReg(e);
        PlanIter[] pushedExternalIters = null;
        if (e.getPushedExternals() != null) {
            ArrayList<Expr> pushedExternalExprs = e.getPushedExternals();
            int size = pushedExternalExprs.size();
            pushedExternalIters = new PlanIter[size];
            for (int i = 0; i < size; ++i) {
                PlanIter iter;
                Expr expr = pushedExternalExprs.get(i);
                if (expr == null) {
                    pushedExternalIters[i] = null;
                    continue;
                }
                this.theWalker.walk(expr);
                pushedExternalIters[i] = iter = this.theIters.pop();
            }
        }
        BaseTableIter tableIter = new BaseTableIter(e, resultReg, tupleRegs, e.getTable(), e.getDirection(), e.getPrimaryKey(), e.getSecondaryKey(), e.getRange(), e.getUsesCoveringIndex(), e.getEliminateIndexDups(), pushedExternalIters);
        this.theIters.push(tableIter);
        return false;
    }

    @Override
    boolean enter(ExprSFW sfw) {
        sfw.removeUnusedVars();
        int numVars = sfw.getNumVars();
        PlanIter[] fromIters = new PlanIter[numVars];
        String[] varNames = new String[numVars];
        for (int i = 0; i < numVars; ++i) {
            ExprBaseTable tableExpr;
            ExprVar var = sfw.getVar(i);
            Expr domExpr = sfw.getDomainExpr(i);
            this.theWalker.walk(domExpr);
            fromIters[i] = this.theIters.pop();
            varNames[i] = var.getName();
            this.setResultReg(var, fromIters[i].getResultReg());
            if (fromIters[i].producesTuples()) {
                this.setTupleRegs(var, fromIters[i].getTupleRegs());
            }
            if (domExpr.getKind() != Expr.ExprKind.BASE_TABLE || (tableExpr = (ExprBaseTable)domExpr).getFilteringPred() == null) continue;
            this.theWalker.walk(tableExpr.getFilteringPred());
            ((BaseTableIter)fromIters[i]).setFilterIter(this.theIters.pop());
        }
        PlanIter whereIter = null;
        if (sfw.getWhereExpr() != null) {
            this.theWalker.walk(sfw.getWhereExpr());
            whereIter = this.theIters.pop();
        }
        int numFields = sfw.getNumFields();
        PlanIter[] selectIters = new PlanIter[numFields];
        int[] tupleRegs = null;
        int resultReg = this.allocateResultReg(sfw);
        if (sfw.getConstructsSelectRecord()) {
            resultReg = this.allocateResultReg(sfw);
            tupleRegs = new int[numFields];
            for (int i = 0; i < numFields; ++i) {
                this.theWalker.walk(sfw.getFieldExpr(i));
                selectIters[i] = this.theIters.pop();
                tupleRegs[i] = selectIters[i].producesTuples() ? this.allocateLocalReg() : selectIters[i].getResultReg();
            }
        } else {
            assert (numFields == 1);
            this.theWalker.walk(sfw.getFieldExpr(0));
            selectIters[0] = this.theIters.pop();
            resultReg = selectIters[0].getResultReg();
        }
        PlanIter offsetIter = null;
        PlanIter limitIter = null;
        if (sfw.getOffset() != null) {
            this.theWalker.walk(sfw.getOffset());
            offsetIter = this.theIters.pop();
        }
        if (sfw.getLimit() != null) {
            this.theWalker.walk(sfw.getLimit());
            limitIter = this.theIters.pop();
        }
        SFWIter sfwIter = new SFWIter(sfw, resultReg, tupleRegs, fromIters, varNames, whereIter, selectIters, sfw.getFieldNamesArray(), offsetIter, limitIter);
        this.theIters.push(sfwIter);
        return false;
    }
}

