/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.param;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LoadParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ParameterMap> maps;
    private int version = 1;
    private transient SortedMap<String, ParameterMap> parameterMaps = new TreeMap<String, ParameterMap>();

    public static LoadParameters getParameters(File file, Logger logger) {
        LoadParameters lp = new LoadParameters();
        lp.load(file, false, true, logger);
        return lp;
    }

    public static LoadParameters getParametersByType(File file) {
        return LoadParameters.getParametersByType(file, null);
    }

    public static LoadParameters getParametersByType(File file, Logger logger) {
        LoadParameters lp = new LoadParameters();
        lp.load(file, true, true, logger);
        return lp;
    }

    public void saveParameters(File file) {
        PrintWriter writer = null;
        File temp = null;
        try {
            temp = File.createTempFile(file.getName(), null, file.getParentFile());
            FileOutputStream fos = new FileOutputStream(temp);
            writer = new PrintWriter(fos);
            writer.print("<!-- Do not edit this file, it is machine generated. -->\n");
            writer.printf("<config version=\"%d\">\n", this.version);
            for (ParameterMap map : this.parameterMaps.values()) {
                map.write(writer);
            }
            writer.printf("</config>\n", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem creating config file: " + temp + ": " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (temp != null) {
            int nretries = 5;
            int sleepMs = 200;
            for (int i = 0; i < 5; ++i) {
                if (temp.renameTo(file)) {
                    return;
                }
                String os = System.getProperty("os.name");
                if (os.indexOf("Windows") != -1) {
                    file.delete();
                }
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new IllegalStateException("Unable to save config file: " + file);
    }

    List<ParameterMap> getMaps() {
        return new ArrayList<ParameterMap>(this.parameterMaps.values());
    }

    public void addMap(ParameterMap map) {
        if (map == null) {
            return;
        }
        if (map.getName() == null || map.getType() == null) {
            throw new IllegalArgumentException("ParameterMap must have a name and type");
        }
        this.parameterMaps.put(map.getName(), map);
    }

    public ParameterMap removeMap(String name) {
        return (ParameterMap)this.parameterMaps.remove(name);
    }

    public ParameterMap removeMapByType(String type) {
        ParameterMap map = null;
        Iterator<ParameterMap> itr = this.parameterMaps.values().iterator();
        while (itr.hasNext()) {
            ParameterMap canidate = itr.next();
            if (!type.equals(canidate.getType())) continue;
            itr.remove();
            map = canidate;
        }
        return map;
    }

    public ParameterMap getMap(String name, String type) {
        ParameterMap map = (ParameterMap)this.parameterMaps.get(name);
        if (map != null && type.equals(map.getType())) {
            return map;
        }
        return null;
    }

    public ParameterMap getMapByType(String type) {
        for (ParameterMap map : this.parameterMaps.values()) {
            if (!type.equals(map.getType())) continue;
            return map;
        }
        return null;
    }

    public List<ParameterMap> getAllMaps(String type) {
        ArrayList<ParameterMap> list = new ArrayList<ParameterMap>();
        for (ParameterMap map : this.parameterMaps.values()) {
            if (!type.equals(map.getType())) continue;
            list.add(map);
        }
        return list;
    }

    public ParameterMap getMap(String name) {
        return (ParameterMap)this.parameterMaps.get(name);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    private void load(File file, boolean useTypes, boolean ignoreUnknown, Logger logger) {
        InputStream is = null;
        try {
            URL url = file.toURI().toURL();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader xr = factory.newSAXParser().getXMLReader();
            ConfigHandler handler = new ConfigHandler(useTypes, ignoreUnknown, this, logger);
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            is = url.openStream();
            xr.parse(new InputSource(is));
        }
        catch (SAXParseException e) {
            String msg = "Error while parsing line " + e.getLineNumber() + " of " + file + ": " + e.getMessage();
            throw new IllegalStateException(msg);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Problem with XML: " + e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (MalformedURLException me) {
            throw new IllegalStateException("Could not translate file to URL: " + file);
        }
        catch (IOException io) {
            throw new IllegalStateException("IOException parsing file: " + file + ": " + io);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parameterMaps = new TreeMap<String, ParameterMap>();
        if (this.maps == null) {
            return;
        }
        for (ParameterMap map : this.maps) {
            this.parameterMaps.put(map.getName(), map);
        }
        this.maps = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maps = this.getMaps();
        out.defaultWriteObject();
        this.maps = null;
    }

    private static class ConfigHandler
    extends DefaultHandler {
        Locator locator;
        ParameterMap curMap;
        final boolean useTypes;
        final boolean ignoreUnknown;
        final Logger logger;
        final LoadParameters lp;

        private ConfigHandler(boolean useTypes, boolean ignoreUnknown, LoadParameters lp, Logger logger) {
            this.logger = logger;
            this.useTypes = useTypes;
            this.ignoreUnknown = ignoreUnknown;
            this.lp = lp;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("config")) {
                String stringVersion = attributes.getValue("version");
                if (stringVersion == null) {
                    throw new SAXParseException("config element must specify version", this.locator);
                }
                this.lp.setVersion(Integer.parseInt(stringVersion));
            } else if (qName.equals("component")) {
                String curComponent = attributes.getValue("name");
                String curType = attributes.getValue("type");
                String validateString = attributes.getValue("validate");
                boolean validate = true;
                if (validateString != null) {
                    validate = Boolean.parseBoolean(validateString);
                }
                this.curMap = new ParameterMap(curComponent, curType, validate, this.lp.getVersion());
                if (curComponent == null || curType == null) {
                    throw new SAXParseException("component element must specify name and type", this.locator);
                }
            } else if (qName.equals("property")) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                if (attributes.getLength() < 2 || attributes.getLength() > 3 || name == null || value == null) {
                    throw new SAXParseException("property element must only have 'name', 'value' and (optional) 'type' attributes", this.locator);
                }
                if (this.curMap == null) {
                    throw new SAXParseException("property elements are not allowed at global scope", this.locator);
                }
                if (this.curMap.exists(name)) {
                    throw new SAXParseException("Duplicate property: " + name, this.locator);
                }
                String type = attributes.getValue("type");
                Parameter param = null;
                if (this.useTypes) {
                    if (type == null) {
                        throw new SAXParseException("type attribute required on property element in this path", this.locator);
                    }
                    param = Parameter.createKnownType((String)name, (String)value, (String)type);
                    if (param != null) {
                        this.curMap.put(param);
                    } else if (this.logger != null) {
                        this.logger.warning("Could not create parameter: " + name);
                    }
                } else if (!this.curMap.setParameter(name, value, type, this.ignoreUnknown) && this.logger != null) {
                    this.logger.warning("Ignoring unknown parameter: " + name);
                }
            } else {
                throw new SAXParseException("Unknown element '" + qName + "'", this.locator);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXParseException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXParseException {
            if (qName.equals("component")) {
                this.lp.addMap(this.curMap);
                this.curMap = null;
            } else if (qName.equals("property")) {
                // empty if block
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

