/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.measurement;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum PerfStatType {
    USER_SINGLE_OP_INT(100, true, "AllSingleKeyOperations"),
    USER_SINGLE_OP_CUM(101, false, "AllSingleKeyOperations"),
    USER_MULTI_OP_INT(120, true, "AllMultiKeyOperations"),
    USER_MULTI_OP_CUM(121, false, "AllMultiKeyOperations"),
    GET_INT(200, true, "Gets"),
    GET_CUM(201, false, "Gets"),
    PUT_INT(301, true, "Puts"),
    PUT_IF_ABSENT_INT(302, true, "PutIfAbsent"),
    PUT_IF_PRESENT_INT(303, true, "PutIfPresent"),
    PUT_IF_VERSION_INT(304, true, "PutIfVersion"),
    PUT_CUM(321, false, "Puts"),
    PUT_IF_ABSENT_CUM(322, false, "PutIfAbsent"),
    PUT_IF_PRESENT_CUM(323, false, "PutIfPresent"),
    PUT_IF_VERSION_CUM(324, false, "PutIfVersion"),
    DELETE_INT(401, true, "Deletes"),
    DELETE_IF_VERSION_INT(402, true, "DeleteIfVersion"),
    DELETE_CUM(421, false, "Deletes"),
    DELETE_IF_VERSION_CUM(422, false, "DeleteIfVersion"),
    MULTI_GET_INT(500, true, "MultiGets"),
    MULTI_GET_KEYS_INT(501, true, "MultiGetKeys"),
    MULTI_GET_ITERATOR_INT(502, true, "MultiGetIterator"),
    MULTI_GET_KEYS_ITERATOR_INT(503, true, "MultiGetKeysIterator"),
    MULTI_GET_CUM(520, false, "MultiGets"),
    MULTI_GET_KEYS_CUM(521, false, "MultiGetKeys"),
    MULTI_GET_ITERATOR_CUM(522, false, "MultiGetIterator"),
    MULTI_GET_KEYS_ITERATOR_CUM(523, false, "MultiGetKeysIterator"),
    STORE_ITERATOR_INT(600, true, "StoreIterator"),
    STORE_KEYS_ITERATOR_INT(601, true, "StoreKeysIterator"),
    STORE_ITERATOR_CUM(620, false, "StoreIterator"),
    STORE_KEYS_ITERATOR_CUM(621, false, "StoreKeysIterator"),
    MULTI_DELETE_INT(700, true, "MultiDeletes"),
    MULTI_DELETE_CUM(720, false, "MultiDeletes"),
    EXECUTE_INT(800, true, "Executes"),
    EXECUTE_CUM(820, false, "Executes"),
    NOP_INT(900, true, "NOPs"),
    NOP_CUM(920, false, "NOPs"),
    INDEX_ITERATOR_INT(1000, true, "IndexIterator"),
    INDEX_KEYS_ITERATOR_INT(1001, true, "IndexKeysIterator"),
    INDEX_ITERATOR_CUM(1020, false, "IndexIterator"),
    INDEX_KEYS_ITERATOR_CUM(1021, false, "IndexKeysIterator"),
    QUERY_SINGLE_PARTITION_INT(1100, true, "QuerySinglePartition"),
    QUERY_MULTI_PARTITION_INT(1101, true, "QueryMultiPartition"),
    QUERY_MULTI_SHARD_INT(1202, true, "QueryMultiShard"),
    QUERY_SINGLE_PARTITION_CUM(1120, false, "QuerySinglePartition"),
    QUERY_MULTI_PARTITION_CUM(1121, false, "QueryMultiPartition"),
    QUERY_MULTI_SHARD_CUM(1122, false, "QueryMultiShard"),
    PUT_BATCH_INT(1200, true, "BulkPut"),
    PUT_BATCH_CUM(1220, false, "BulkPut"),
    MULTI_GET_BATCH_INT(1300, true, "BulkGet"),
    MULTI_GET_BATCH_KEYS_INT(1301, true, "BulkGetKeys"),
    MULTI_GET_BATCH_TABLE_INT(1302, true, "BulkGetTable"),
    MULTI_GET_BATCH_TABLE_KEYS_INT(1303, true, "BulkGetTableKeys"),
    MULTI_GET_BATCH_CUM(1320, false, "BulkGet"),
    MULTI_GET_BATCH_KEYS_CUM(1321, false, "BulkGetKeys"),
    MULTI_GET_BATCH_TABLE_CUM(1322, false, "BulkGetTable"),
    MULTI_GET_BATCH_TABLE_KEYS_CUM(1323, false, "BulkGetTableKeys");

    public static Map<Integer, PerfStatType> idMap;
    private final int id;
    private final String name;
    private PerfStatType parent;

    public static PerfStatType getType(int id) {
        return idMap.get(id);
    }

    public static PerfStatType[] getDetailedStats() {
        return new PerfStatType[]{NOP_INT, GET_INT, PUT_INT, PUT_IF_ABSENT_INT, PUT_IF_PRESENT_INT, PUT_IF_VERSION_INT, DELETE_INT, DELETE_IF_VERSION_INT, MULTI_GET_INT, MULTI_GET_KEYS_INT, MULTI_GET_ITERATOR_INT, MULTI_GET_KEYS_ITERATOR_INT, STORE_ITERATOR_INT, STORE_KEYS_ITERATOR_INT, MULTI_DELETE_INT, EXECUTE_INT, INDEX_ITERATOR_INT, INDEX_KEYS_ITERATOR_INT, QUERY_SINGLE_PARTITION_INT, QUERY_MULTI_PARTITION_INT, QUERY_MULTI_SHARD_INT, PUT_BATCH_INT, MULTI_GET_BATCH_INT, MULTI_GET_BATCH_KEYS_INT, MULTI_GET_BATCH_TABLE_INT, MULTI_GET_BATCH_TABLE_KEYS_INT};
    }

    public static PerfStatType[] getSummaryStats() {
        return new PerfStatType[]{USER_SINGLE_OP_INT, USER_MULTI_OP_INT};
    }

    private PerfStatType(int id, boolean isInterval, String name) {
        this.id = id;
        this.name = name + (isInterval ? "_Interval" : "_Cumulative");
    }

    private void setParent(PerfStatType parent1) {
        this.parent = parent1;
    }

    public int getId() {
        return this.id;
    }

    public PerfStatType getParent() {
        return this.parent;
    }

    public String toString() {
        return this.name;
    }

    static {
        idMap = new HashMap<Integer, PerfStatType>();
        GET_INT.setParent(USER_SINGLE_OP_INT);
        GET_CUM.setParent(USER_SINGLE_OP_CUM);
        PUT_INT.setParent(USER_SINGLE_OP_INT);
        PUT_IF_ABSENT_INT.setParent(USER_SINGLE_OP_INT);
        PUT_IF_PRESENT_INT.setParent(USER_SINGLE_OP_INT);
        PUT_IF_VERSION_INT.setParent(USER_SINGLE_OP_INT);
        PUT_CUM.setParent(USER_SINGLE_OP_CUM);
        PUT_IF_ABSENT_CUM.setParent(USER_SINGLE_OP_CUM);
        PUT_IF_PRESENT_CUM.setParent(USER_SINGLE_OP_CUM);
        PUT_IF_VERSION_CUM.setParent(USER_SINGLE_OP_CUM);
        DELETE_INT.setParent(USER_SINGLE_OP_INT);
        DELETE_IF_VERSION_INT.setParent(USER_SINGLE_OP_INT);
        DELETE_CUM.setParent(USER_SINGLE_OP_CUM);
        DELETE_IF_VERSION_CUM.setParent(USER_SINGLE_OP_CUM);
        MULTI_GET_INT.setParent(USER_MULTI_OP_INT);
        MULTI_GET_KEYS_INT.setParent(USER_MULTI_OP_INT);
        MULTI_GET_ITERATOR_INT.setParent(USER_MULTI_OP_INT);
        MULTI_GET_KEYS_ITERATOR_INT.setParent(USER_MULTI_OP_INT);
        MULTI_GET_CUM.setParent(USER_MULTI_OP_CUM);
        MULTI_GET_KEYS_CUM.setParent(USER_MULTI_OP_CUM);
        MULTI_GET_ITERATOR_CUM.setParent(USER_MULTI_OP_CUM);
        MULTI_GET_KEYS_ITERATOR_CUM.setParent(USER_MULTI_OP_CUM);
        STORE_ITERATOR_INT.setParent(USER_MULTI_OP_INT);
        STORE_KEYS_ITERATOR_INT.setParent(USER_MULTI_OP_INT);
        STORE_ITERATOR_CUM.setParent(USER_MULTI_OP_CUM);
        STORE_KEYS_ITERATOR_CUM.setParent(USER_MULTI_OP_CUM);
        MULTI_DELETE_INT.setParent(USER_MULTI_OP_INT);
        MULTI_DELETE_CUM.setParent(USER_MULTI_OP_CUM);
        EXECUTE_INT.setParent(USER_MULTI_OP_INT);
        EXECUTE_CUM.setParent(USER_MULTI_OP_CUM);
        INDEX_ITERATOR_INT.setParent(USER_MULTI_OP_INT);
        INDEX_KEYS_ITERATOR_INT.setParent(USER_MULTI_OP_INT);
        INDEX_ITERATOR_CUM.setParent(USER_MULTI_OP_CUM);
        INDEX_KEYS_ITERATOR_CUM.setParent(USER_MULTI_OP_CUM);
        QUERY_SINGLE_PARTITION_INT.setParent(USER_MULTI_OP_INT);
        QUERY_MULTI_PARTITION_INT.setParent(USER_MULTI_OP_INT);
        QUERY_MULTI_SHARD_INT.setParent(USER_MULTI_OP_INT);
        QUERY_SINGLE_PARTITION_CUM.setParent(USER_MULTI_OP_CUM);
        QUERY_MULTI_PARTITION_CUM.setParent(USER_MULTI_OP_CUM);
        QUERY_MULTI_SHARD_CUM.setParent(USER_MULTI_OP_CUM);
        PUT_BATCH_INT.setParent(USER_MULTI_OP_INT);
        PUT_BATCH_CUM.setParent(USER_MULTI_OP_CUM);
        MULTI_GET_BATCH_INT.setParent(USER_MULTI_OP_INT);
        MULTI_GET_BATCH_KEYS_INT.setParent(USER_MULTI_OP_INT);
        MULTI_GET_BATCH_TABLE_INT.setParent(USER_MULTI_OP_INT);
        MULTI_GET_BATCH_TABLE_KEYS_INT.setParent(USER_MULTI_OP_INT);
        MULTI_GET_BATCH_CUM.setParent(USER_MULTI_OP_CUM);
        MULTI_GET_BATCH_KEYS_CUM.setParent(USER_MULTI_OP_CUM);
        MULTI_GET_BATCH_TABLE_CUM.setParent(USER_MULTI_OP_CUM);
        MULTI_GET_BATCH_TABLE_KEYS_CUM.setParent(USER_MULTI_OP_CUM);
        for (PerfStatType t : EnumSet.allOf(PerfStatType.class)) {
            idMap.put(t.getId(), t);
        }
    }
}

