/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.measurement;

import com.sleepycat.utilint.Latency;
import java.io.Serializable;
import oracle.kv.impl.measurement.PerfStatType;
import oracle.kv.impl.util.FormatUtils;

public class LatencyInfo
implements Serializable {
    public static final String ZEROS = "0,0,0,0,0,0,0,0";
    public static final LatencyInfo ZERO_MEASUREMENT = new LatencyInfo(PerfStatType.NOP_INT, 0L, 0L, new Latency(0));
    private static final long serialVersionUID = 1L;
    private final int perfStatId;
    private final Latency latency;
    private boolean hasBeenRolledUp = false;
    private long startMillis;
    private long endMillis;

    public LatencyInfo(PerfStatType perfType, long startMillis, long endMillis, Latency latency) {
        this.perfStatId = perfType.getId();
        this.startMillis = startMillis;
        this.endMillis = endMillis;
        this.latency = latency;
    }

    public LatencyInfo(PerfStatType perfType, LatencyInfo other) {
        this.perfStatId = perfType.getId();
        this.startMillis = other.startMillis;
        this.endMillis = other.endMillis;
        this.latency = other.latency.clone();
    }

    public long getThroughputPerSec() {
        long elapsedMillis = this.endMillis - this.startMillis;
        if (elapsedMillis == 0L) {
            return 0L;
        }
        long longOps = this.latency.getTotalOps();
        long throughput = longOps * 1000L / elapsedMillis;
        if (throughput > 0L) {
            return throughput;
        }
        if (longOps > 0L) {
            return 1L;
        }
        return 0L;
    }

    public static String getCSVHeader(String opName) {
        String prefix = '\"' + opName + "\n";
        String names = (prefix + "TotalOps" + '\"' + "," + prefix + "PerSec" + '\"' + "," + prefix + "TotalReq" + '\"' + "," + prefix + "Min" + '\"' + "," + prefix + "Max" + '\"' + "," + prefix + "Avg" + '\"' + "," + prefix + "95th" + '\"' + "," + prefix + "99th" + '\"').intern();
        return names;
    }

    public String getCSVStats() {
        return this.latency.getTotalOps() + "," + this.getThroughputPerSec() + "," + this.latency.getTotalRequests() + "," + this.latency.getMin() + "," + this.latency.getMax() + "," + this.latency.getAvg() + "," + this.latency.get95thPercent() + "," + this.latency.get99thPercent();
    }

    public void rollup(LatencyInfo other) {
        this.hasBeenRolledUp = true;
        this.latency.rollup(other.latency);
        if (other.startMillis < this.startMillis) {
            this.startMillis = other.startMillis;
        }
        if (other.endMillis > this.endMillis) {
            this.endMillis = other.endMillis;
        }
    }

    public int getPerfStatId() {
        return this.perfStatId;
    }

    public String toString() {
        PerfStatType type = PerfStatType.getType(this.perfStatId);
        String latencyVals = "perSec=" + this.getThroughputPerSec() + " totalOps=" + this.latency.getTotalOps() + " totalReq=" + this.latency.getTotalRequests() + " min=" + this.latency.getMin() + " max=" + this.latency.getMax() + " avg=" + this.latency.getAvg();
        if (!this.hasBeenRolledUp) {
            latencyVals = latencyVals + " 95th=" + this.latency.get95thPercent() + " 99th=" + this.latency.get99thPercent();
            if (this.latency.getRequestsOverflow() > 0) {
                latencyVals = latencyVals + " overflow=" + this.latency.getRequestsOverflow();
            }
        }
        return (Object)((Object)type) + " (" + FormatUtils.formatTime(this.endMillis) + ") " + latencyVals;
    }

    public long getStart() {
        return this.startMillis;
    }

    public long getEnd() {
        return this.endMillis;
    }

    public Latency getLatency() {
        return this.latency;
    }
}

