/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.TableImpl;

public class TablePath {
    private final FieldMap fieldMap;
    private List<String> steps;
    private String pathName;
    private boolean isComplex;

    public TablePath(TableImpl table, String path) {
        this(table.getFieldMap(), path);
    }

    protected TablePath(FieldMap fieldMap, String path) {
        this.fieldMap = fieldMap;
        this.steps = path != null ? TablePath.parsePathName(path) : new ArrayList<String>();
        this.isComplex = this.steps.size() > 1;
    }

    public TablePath(FieldMap fieldMap, List<String> steps) {
        this.fieldMap = fieldMap;
        this.steps = steps;
        this.isComplex = steps.size() > 1;
    }

    public String toString() {
        return this.getPathName();
    }

    public int hashCode() {
        return this.getPathName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TablePath)) {
            return false;
        }
        TablePath other = (TablePath)o;
        if (this.steps.size() != other.steps.size()) {
            return false;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            if (this.steps.get(i).equalsIgnoreCase(other.steps.get(i))) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.pathName = null;
        this.steps.clear();
        this.isComplex = false;
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    final FieldMap getFieldMap() {
        return this.fieldMap;
    }

    public final boolean isComplex() {
        return this.isComplex;
    }

    public int numSteps() {
        return this.steps.size();
    }

    public final List<String> getSteps() {
        return this.steps;
    }

    public final String getStep(int i) {
        return this.steps.get(i);
    }

    public final void add(String step) {
        this.steps.add(step);
        if (this.steps.size() > 1) {
            this.isComplex = true;
        }
        this.pathName = null;
    }

    public final void add(int pos, String step) {
        this.steps.add(pos, step);
        if (this.steps.size() > 1) {
            this.isComplex = true;
        }
        this.pathName = null;
    }

    public void reverseSteps() {
        Collections.reverse(this.steps);
    }

    ListIterator<String> iterator() {
        return this.steps.listIterator();
    }

    public final String getLastStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    public FieldDefImpl getFirstDef() {
        return this.fieldMap.getFieldDef(this.steps.get(0));
    }

    public final String getPathName() {
        if (this.pathName == null && this.steps != null) {
            String step = this.steps.get(0);
            assert (!step.equals("[]"));
            assert (!step.equals("_key"));
            StringBuilder sb = new StringBuilder(step);
            for (int i = 1; i < this.steps.size(); ++i) {
                step = this.steps.get(i);
                if (step.equals("_key")) {
                    sb.append(".keys()");
                    assert (i == this.steps.size() - 1);
                    continue;
                }
                if (this.steps.get(i).equals("[]")) {
                    StringBuilder sb2 = new StringBuilder();
                    for (int j = 0; j < i; ++j) {
                        sb2.append(this.steps.get(j));
                        if (j >= i - 1) continue;
                        sb2.append(".");
                    }
                    FieldDefImpl pathDef = TableImpl.findTableField(this.fieldMap, sb2.toString());
                    if (pathDef.isArray()) {
                        sb.append(step);
                        continue;
                    }
                    assert (pathDef.isMap());
                    sb.append(".values()");
                    continue;
                }
                sb.append('.').append(step);
            }
            this.pathName = sb.toString();
        }
        return this.pathName;
    }

    public final String concatPathSteps() {
        Iterator<String> iter = this.steps.iterator();
        return TablePath.createPathName(iter);
    }

    public static List<String> parsePathName(String pathname) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (char ch : pathname.toCharArray()) {
            if (ch == '.') {
                if (sb.length() == 0) {
                    throw new IllegalArgumentException("Malformed field name: " + pathname);
                }
                list.add(sb.toString());
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }

    public static String createPathName(Iterator<String> iter) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            String current = iter.next();
            sb.append(current);
            if (!iter.hasNext()) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

