/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.kv.Key;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.util.ArrayPosition;
import oracle.kv.table.FieldRange;
import oracle.kv.table.Row;
import oracle.kv.table.Table;

public class TableKey {
    private final ArrayList<String> major;
    private final ArrayList<String> minor;
    private final ArrayPosition pkIterator;
    private final Iterator<String> majorIterator;
    private final boolean allowPartial;
    private final Row row;
    private final TableImpl table;
    private Key key;
    private boolean majorComplete;
    private boolean keyComplete;
    private boolean done;
    private ArrayList<String> current;

    private TableKey(TableImpl table, Row row, boolean allowPartial) {
        this.row = row;
        this.allowPartial = allowPartial;
        this.major = new ArrayList();
        this.minor = new ArrayList();
        this.pkIterator = new ArrayPosition(table.getPrimaryKey().size());
        this.majorIterator = table.getShardKey().iterator();
        this.current = this.major;
        this.keyComplete = true;
        this.table = table;
    }

    public static TableKey createKey(Table table, Row row, boolean allowPartial) {
        if (row.size() == 0) {
            if (!allowPartial) {
                throw new IllegalArgumentException("Primary key is empty");
            }
            return new TableKey((TableImpl)table, row, allowPartial).create();
        }
        return new TableKey((TableImpl)table, row, allowPartial).create();
    }

    public TableKey create() {
        this.createPrimaryKey(this.table);
        this.key = Key.createKey(this.major, this.minor);
        return this;
    }

    TableImpl getTable() {
        return this.table;
    }

    public boolean getKeyComplete() {
        return this.keyComplete;
    }

    public boolean getMajorKeyComplete() {
        return this.majorComplete;
    }

    public Key getKey() {
        return this.key;
    }

    RowImpl getRow() {
        return (RowImpl)this.row;
    }

    public byte[] getKeyBytes() {
        return this.key.toByteArray();
    }

    private void incrementMajor() {
        if (this.majorIterator.hasNext()) {
            this.majorIterator.next();
        } else {
            this.current = this.minor;
            this.majorComplete = true;
        }
    }

    private void createPrimaryKey(TableImpl currentTable) {
        if (currentTable.getParent() != null) {
            this.createPrimaryKey((TableImpl)currentTable.getParent());
        }
        if (!this.done) {
            this.current.add(currentTable.getIdString());
        }
        int lastPrimKeyCol = currentTable.getPrimaryKeySize() - 1;
        while (this.pkIterator.hasNext()) {
            FieldValueImpl value;
            int pkFieldPos;
            int pos = this.pkIterator.next();
            int n = pkFieldPos = this.row instanceof PrimaryKeyImpl ? pos : this.table.getPrimKeyPositions()[pos];
            if (!this.done) {
                this.incrementMajor();
            }
            if ((value = (FieldValueImpl)this.row.get(pkFieldPos)) != null) {
                if (!this.keyComplete) {
                    throw new IllegalArgumentException("A required field is missing from the Primary Key");
                }
                FieldDefImpl type = ((RowImpl)this.row).getFieldDef(pkFieldPos);
                this.current.add(value.formatForKey(type, currentTable.getPrimaryKeySize(pkFieldPos)));
            } else {
                this.keyComplete = false;
                if (!this.allowPartial) {
                    String fname = this.table.getRowDef().getFieldName(pkFieldPos);
                    throw new IllegalArgumentException("Missing primary key field: " + fname);
                }
                this.done = true;
            }
            if (pos != lastPrimKeyCol) continue;
            if (this.done) break;
            this.incrementMajor();
            break;
        }
    }

    void validateFieldOrder(FieldRange range) {
        if (range != null) {
            List<String> primaryKey = this.table.getPrimaryKey();
            int index = primaryKey.indexOf(range.getFieldName());
            if (index < 0) {
                throw new IllegalArgumentException("Field is not part of primary key: " + range.getFieldName());
            }
            if (this.row.size() < index) {
                throw new IllegalArgumentException("PrimaryKey is missing fields more significant than field: " + range.getFieldName());
            }
            if (this.row.size() > index) {
                throw new IllegalArgumentException("PrimaryKey has extra fields beyond field: " + range.getFieldName());
            }
        }
    }
}

