/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.NumberDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class NumberDefImpl
extends FieldDefImpl
implements NumberDef {
    private static final long serialVersionUID = 1L;

    NumberDefImpl(String description) {
        super(FieldDef.Type.NUMBER, description);
    }

    NumberDefImpl() {
        super(FieldDef.Type.NUMBER);
    }

    private NumberDefImpl(NumberDefImpl impl) {
        super(impl);
    }

    @Override
    public NumberDefImpl clone() {
        return new NumberDefImpl(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NumberDefImpl;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public NumberDef asNumber() {
        return this;
    }

    @Override
    public NumberValueImpl createNumber(int value) {
        return new NumberValueImpl(value);
    }

    @Override
    public NumberValueImpl createNumber(long value) {
        return new NumberValueImpl(value);
    }

    @Override
    public NumberValueImpl createNumber(float value) {
        return new NumberValueImpl(BigDecimal.valueOf(value));
    }

    @Override
    public NumberValueImpl createNumber(double value) {
        return new NumberValueImpl(BigDecimal.valueOf(value));
    }

    @Override
    public NumberValueImpl createNumber(BigDecimal value) {
        return new NumberValueImpl(value);
    }

    @Override
    public NumberValueImpl createNumber(String value) {
        return new NumberValueImpl(value);
    }

    @Override
    public short getRequiredSerialVersion() {
        return 13;
    }

    @Override
    NumberValueImpl createNumber(byte[] value) {
        return new NumberValueImpl(value);
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isNumber() || superType.isAny() || superType.isAnyJsonAtomic() || superType.isAnyAtomic() || superType.isJson();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isNumber()) {
            throw new IllegalArgumentException("Default value for type NUMBER is not Number type");
        }
        return this.createNumber(node.getDecimalValue());
    }
}

