/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.math.BigDecimal;
import java.sql.Timestamp;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;

public class IndexKeyImpl
extends RecordValueImpl
implements IndexKey {
    private static final long serialVersionUID = 1L;
    final IndexImpl index;

    IndexKeyImpl(IndexImpl index, RecordDefImpl indexKeyDef) {
        super(indexKeyDef);
        this.index = index;
    }

    private IndexKeyImpl(IndexKeyImpl other) {
        super(other);
        this.index = other.index;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public IndexKeyImpl clone() {
        return new IndexKeyImpl(this);
    }

    @Override
    public IndexKey asIndexKey() {
        return this;
    }

    @Override
    public boolean isIndexKey() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IndexKeyImpl) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void validate() {
        this.validateIndexFields();
    }

    public int getKeySize() {
        return this.index.serializeIndexKey(this).length;
    }

    TableImpl getTable() {
        return this.index.getTableImpl();
    }

    public IndexImpl getIndexImpl() {
        return this.index;
    }

    public boolean isComplete() {
        return this.size() == this.getNumFields();
    }

    public boolean incrementIndexKey() {
        int fieldIndex;
        RecordDefImpl def = this.getDefinition();
        FieldValue[] values = new FieldValue[def.getNumFields()];
        for (fieldIndex = 0; fieldIndex < def.getNumFields(); ++fieldIndex) {
            values[fieldIndex] = this.get(fieldIndex);
            if (values[fieldIndex] == null) break;
        }
        assert (fieldIndex > 0);
        FieldValueImpl fvi = this.getNextValue((FieldValueImpl)values[--fieldIndex], this.index.allowNull(fieldIndex));
        while (fvi == null) {
            fvi = this.getMinimumValue((FieldValueImpl)values[fieldIndex], def.getField(fieldIndex));
            this.put(def.getFieldName(fieldIndex), (FieldValue)fvi);
            if (--fieldIndex >= 0) {
                fvi = this.getNextValue((FieldValueImpl)values[fieldIndex], this.index.allowNull(fieldIndex));
                continue;
            }
            return false;
        }
        assert (fvi != null && fieldIndex >= 0);
        this.put(fieldIndex, (FieldValue)fvi);
        return true;
    }

    @Override
    protected String getClassNameForError() {
        return "IndexKey";
    }

    private FieldValueImpl getNextValue(FieldValueImpl value, boolean allowNull) {
        if (value.isNull()) {
            assert (allowNull);
            return null;
        }
        FieldValueImpl next = value.getNextValue();
        if (next == null && allowNull) {
            next = NullValueImpl.getInstance();
        }
        return next;
    }

    private FieldValueImpl getMinimumValue(FieldValueImpl value, FieldDef def) {
        if (value.isNull()) {
            return this.getMinValueOfType(def);
        }
        return value.getMinimumValue();
    }

    private FieldValueImpl getMinValueOfType(FieldDef def) {
        FieldDef.Type type = def.getType();
        FieldValue fv = null;
        switch (type) {
            case INTEGER: {
                fv = def.createInteger(0);
                break;
            }
            case LONG: {
                fv = def.createLong(0L);
                break;
            }
            case FLOAT: {
                fv = def.createFloat(0.0f);
                break;
            }
            case DOUBLE: {
                fv = def.createDouble(0.0);
                break;
            }
            case NUMBER: {
                fv = def.createNumber(BigDecimal.ZERO);
                break;
            }
            case STRING: {
                fv = def.createString("");
                break;
            }
            case ENUM: {
                return ((EnumDefImpl)def).createEnum(0);
            }
            case TIMESTAMP: {
                fv = ((TimestampDefImpl)def).createTimestamp(new Timestamp(0L));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type for index key: " + type);
            }
        }
        return ((FieldValueImpl)fv).getMinimumValue();
    }
}

