/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Table;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class IndexImpl
implements Index,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte NULL_INDICATOR = 1;
    private static final byte NOT_NULL_INDICATOR = 0;
    private final String name;
    private final String description;
    private final TableImpl table;
    private final List<String> fields;
    private IndexStatus status;
    private transient List<IndexField> indexFields;
    private transient boolean isMultiKeyMapIndex;
    private transient RecordDefImpl indexKeyDef;
    private final Map<String, String> annotations;
    private final Map<String, String> properties;
    private final boolean isNullSupported;
    static final String INDEX_NULL_DISABLE = "test.index.null.disable";

    public IndexImpl(String name, TableImpl table, List<String> fields, String description) {
        this(name, table, fields, null, null, description);
    }

    public IndexImpl(String name, TableImpl table, List<String> fields, Map<String, String> annotations, Map<String, String> properties, String description) {
        this.name = name;
        this.table = table;
        this.fields = IndexImpl.translateFields(fields);
        this.annotations = annotations;
        this.properties = properties;
        this.description = description;
        this.status = IndexStatus.TRANSIENT;
        this.isNullSupported = this.isEnableNullSupported();
        this.validate();
        assert (this.indexFields != null);
    }

    public static void populateMapFromAnnotatedFields(List<AnnotatedField> fields, List<String> fieldNames, Map<String, String> annotations) {
        for (AnnotatedField f : fields) {
            String fieldName = f.getFieldName();
            String translatedFieldName = TableImpl.translateFromExternalField(fieldName);
            fieldName = translatedFieldName == null ? fieldName : translatedFieldName;
            fieldNames.add(fieldName);
            annotations.put(fieldName, f.getAnnotation());
        }
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isMapBothIndex() {
        List<IndexField> ipaths = this.getIndexFields();
        boolean haveMapKey = false;
        boolean haveMapValue = false;
        if (!this.isMultiKeyMapIndex) {
            return false;
        }
        for (IndexField ipath : ipaths) {
            if (ipath.isMapKey()) {
                haveMapKey = true;
                if (!haveMapValue) continue;
                return false;
            }
            if (!ipath.isMapValue()) continue;
            haveMapValue = true;
            if (!haveMapKey) continue;
            break;
        }
        return haveMapKey && haveMapValue;
    }

    @Override
    public List<String> getFields() {
        return this.getIndexKeyDef().getFields();
    }

    public IndexField getIndexPath(int i) {
        return this.indexFields.get(i);
    }

    public List<AnnotatedField> getFieldsWithAnnotations() {
        if (!this.isTextIndex()) {
            throw new IllegalStateException("getFieldsWithAnnotations called on non-text index");
        }
        ArrayList<AnnotatedField> fieldsWithAnnotations = new ArrayList<AnnotatedField>(this.fields.size());
        for (String field : this.fields) {
            fieldsWithAnnotations.add(new AnnotatedField(field, this.annotations.get(field)));
        }
        return fieldsWithAnnotations;
    }

    Map<String, String> getAnnotations() {
        if (this.isTextIndex()) {
            return Collections.unmodifiableMap(this.annotations);
        }
        return Collections.emptyMap();
    }

    Map<String, String> getAnnotationsInternal() {
        return this.annotations;
    }

    public Map<String, String> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        return Collections.emptyMap();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IndexKeyImpl createIndexKey() {
        return new IndexKeyImpl(this, this.getIndexKeyDef());
    }

    public IndexKeyImpl createIndexKeyFromFlattenedRecord(RecordValue value) {
        IndexKeyImpl ikey = this.createIndexKey();
        ikey.copyFrom(value);
        return ikey;
    }

    @Override
    public IndexKeyImpl createIndexKey(RecordValue value) {
        if (value instanceof IndexKey) {
            throw new IllegalArgumentException("Cannot call createIndexKey with IndexKey argument");
        }
        IndexKeyImpl ikey = this.createIndexKey();
        this.populateIndexRecord(ikey, (RecordValueImpl)value);
        return ikey;
    }

    @Override
    public IndexKey createIndexKeyFromJson(String jsonInput, boolean exact) {
        return this.createIndexKeyFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public IndexKey createIndexKeyFromJson(InputStream jsonInput, boolean exact) {
        IndexKeyImpl key = this.createIndexKey();
        ComplexValueImpl.createFromJson((ComplexValueImpl)key, jsonInput, exact, false);
        return key;
    }

    @Override
    public FieldRange createFieldRange(String path) {
        FieldDefImpl ifieldDef = this.getIndexKeyDef().getField(path);
        if (ifieldDef == null) {
            throw new IllegalArgumentException("Field does not exist in index: " + path);
        }
        return new FieldRange(path, ifieldDef, 0);
    }

    private void populateIndexRecord(IndexKeyImpl indexKey, RecordValueImpl value) {
        assert (!(value instanceof IndexKey));
        int i = 0;
        for (IndexField field : this.getIndexFields()) {
            FieldValueImpl v = value.getComplex(field);
            if (v != null) {
                indexKey.put(i, (FieldValue)v);
            }
            ++i;
        }
        indexKey.validate();
    }

    public int numFields() {
        return this.fields.size();
    }

    public boolean isKeyOnly() {
        for (String field : this.fields) {
            if (this.table.isKeyComponent(field)) continue;
            return false;
        }
        return true;
    }

    public boolean isMultiKey() {
        if (!this.isTextIndex()) {
            for (IndexField field : this.getIndexFields()) {
                if (!field.isMultiKey()) continue;
                return true;
            }
        }
        return false;
    }

    public IndexStatus getStatus() {
        return this.status;
    }

    public void setStatus(IndexStatus status) {
        this.status = status;
    }

    public TableImpl getTableImpl() {
        return this.table;
    }

    public List<String> getFieldsInternal() {
        return this.fields;
    }

    public List<IndexField> getIndexFields() {
        if (this.indexFields == null) {
            this.initTransientState();
        }
        return this.indexFields;
    }

    RecordDefImpl getIndexKeyDef() {
        if (this.indexKeyDef == null) {
            this.initTransientState();
        }
        return this.indexKeyDef;
    }

    public String getFieldName(int i) {
        return this.getIndexKeyDef().getFieldName(i);
    }

    public FieldDefImpl getFieldDef(int i) {
        return this.getIndexKeyDef().getFieldDef(i);
    }

    private void initTransientState() {
        assert (this.indexFields == null && this.indexKeyDef == null);
        ArrayList<IndexField> list = new ArrayList<IndexField>(this.fields.size());
        int position = 0;
        for (String field : this.fields) {
            IndexField indexField = new IndexField(this.table, field, position++);
            this.validateIndexField(indexField, false);
            list.add(indexField);
        }
        this.indexFields = list;
        this.indexKeyDef = this.createRecordDef();
    }

    private IndexField findMultiKeyField() {
        for (IndexField field : this.getIndexFields()) {
            if (!field.isMultiKey()) continue;
            return field.getMultiKeyField();
        }
        throw new IllegalStateException("Could not find any multiKeyField in index " + this.name);
    }

    public boolean isMultiKeyMapIndex() {
        return this.isMultiKeyMapIndex;
    }

    public byte[] extractIndexKey(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        if (row != null) {
            return this.serializeIndexKey((RecordValueImpl)row, 0);
        }
        return null;
    }

    public List<byte[]> extractIndexKeys(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        return this.extractIndexKeys(row);
    }

    public List<byte[]> extractIndexKeys(RowImpl row) {
        boolean nullMultiKeyValue;
        if (row == null) {
            return null;
        }
        IndexField indexField = this.findMultiKeyField();
        FieldValueImpl val = row.getComplex(indexField);
        if (val == null) {
            if (!this.isNullSupported()) {
                return null;
            }
            val = NullValueImpl.getInstance();
        }
        boolean bl = nullMultiKeyValue = val.isNull() || val.isArray() && val.asArray().size() == 0 || val.isMap() && val.asMap().size() == 0;
        if (nullMultiKeyValue && !this.isNullSupported()) {
            return null;
        }
        if (!this.isMultiKeyMapIndex || nullMultiKeyValue) {
            int size = nullMultiKeyValue ? 1 : val.asArray().size();
            ArrayList<byte[]> returnList = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                byte[] serKey = this.serializeIndexKey(row, i, nullMultiKeyValue);
                if (serKey == null) continue;
                returnList.add(serKey);
            }
            return returnList;
        }
        assert (val.isMap());
        MapValueImpl mapVal = (MapValueImpl)val;
        ArrayList<byte[]> returnList = new ArrayList<byte[]>(mapVal.size());
        Map<String, FieldValue> map = mapVal.getFieldsInternal();
        for (String mapKey : map.keySet()) {
            byte[] serKey = this.serializeIndexKey((RecordValueImpl)row, mapKey);
            if (serKey == null) continue;
            returnList.add(serKey);
        }
        return returnList;
    }

    public void toJsonNode(ObjectNode node) {
        node.put("name", this.name);
        node.put("type", this.getType().toString().toLowerCase());
        if (this.description != null) {
            node.put("comment", this.description);
        }
        if (this.isMultiKey()) {
            node.put("multi_key", "true");
        }
        ArrayNode fieldArray = node.putArray("fields");
        for (IndexField field : this.getIndexFields()) {
            fieldArray.add(field.getPathName());
        }
        if (this.annotations != null) {
            IndexImpl.putMapAsJson(node, "annotations", this.annotations);
        }
        if (this.properties != null) {
            IndexImpl.putMapAsJson(node, "properties", this.properties);
        }
    }

    private static void putMapAsJson(ObjectNode node, String mapName, Map<String, String> map) {
        ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mapNode.put(entry.getKey(), entry.getValue());
        }
        node.put(mapName, mapNode);
    }

    private void validate() {
        TableImpl.validateIdentifier(this.name, false);
        IndexField multiKeyField = null;
        if (this.fields.isEmpty()) {
            throw new IllegalCommandException("Index requires at least one field");
        }
        assert (this.indexFields == null);
        this.indexFields = new ArrayList<IndexField>(this.fields.size());
        int position = 0;
        for (String field : this.fields) {
            if (field == null || field.length() == 0) {
                throw new IllegalCommandException("Invalid (null or empty) index field name");
            }
            IndexField ifield = new IndexField(this.table, field, position++);
            this.validateIndexField(ifield, true);
            if (ifield.isMultiKey() && !this.isTextIndex()) {
                IndexField mkey = ifield.getMultiKeyField();
                if (multiKeyField != null && !mkey.equals(multiKeyField)) {
                    throw new IllegalCommandException("Indexes may contain only one multiKey field");
                }
                multiKeyField = mkey;
            }
            if (this.indexFields.contains(ifield)) {
                throw new IllegalCommandException("Index already contains the field: " + field);
            }
            this.indexFields.add(ifield);
        }
        assert (this.fields.size() == this.indexFields.size());
        this.indexKeyDef = this.createRecordDef();
        this.table.checkForDuplicateIndex(this);
    }

    private FieldDef validateIndexField(IndexField ipath, boolean isNewIndex) {
        StringBuilder sb = new StringBuilder();
        List<String> steps = ipath.getSteps();
        int numSteps = steps.size();
        int stepIdx = 0;
        String step = steps.get(stepIdx);
        sb.append(step);
        FieldDef stepDef = ipath.getFirstDef();
        if (stepDef == null) {
            throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "There is no field named " + step);
        }
        while (stepIdx < numSteps) {
            if (this.isTextIndex() && (stepDef.isBinary() || stepDef.isFixedBinary() || stepDef.isEnum())) {
                throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "Fields of type " + stepDef.getType() + " cannot participate in a FULLTEXT index.");
            }
            if (stepDef.isRecord()) {
                if (++stepIdx >= numSteps) break;
                step = steps.get(stepIdx);
                if ((stepDef = stepDef.asRecord().getFieldDef(step)) == null) {
                    throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "There is no field named \"" + step + "\" after " + "path " + sb.toString());
                }
                sb.append(".");
                sb.append(step);
                continue;
            }
            if (stepDef.isArray()) {
                if (ipath.isMultiKey()) {
                    throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "The definition contains more than one multi-key " + "fields. The second multi-key field is " + step);
                }
                ipath.setMultiKeyPath(sb.toString(), ipath.getPosition());
                if (stepIdx + 1 < numSteps && steps.get(stepIdx + 1).equals("[]")) {
                    ++stepIdx;
                } else {
                    if (isNewIndex) {
                        throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "Can not index an array as a whole; use " + step + "[]  to index the elements of the array");
                    }
                    ++numSteps;
                    ipath.add(++stepIdx, "[]");
                }
                step = "[]";
                stepDef = stepDef.asArray().getElement();
                sb.append(".");
                sb.append(step);
                continue;
            }
            if (stepDef.isMap()) {
                if (++stepIdx >= numSteps) {
                    throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "Can not index a map as a whole; use " + "[] to index the elements of the map or keys(" + ") to index the keys of the map");
                }
                step = steps.get(stepIdx);
                if (step.equals("[]")) {
                    if (ipath.isMultiKey()) {
                        throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "The definition contains more than one multi-key " + "fields. The second multi-key field is " + step);
                    }
                    ipath.setMultiKeyPath(sb.toString(), ipath.getPosition());
                    ipath.setIsMapValue();
                    this.isMultiKeyMapIndex = true;
                    stepDef = stepDef.asMap().getElement();
                    sb.append(".");
                    sb.append(step);
                    continue;
                }
                if (step.equals("_key")) {
                    if (ipath.isMultiKey()) {
                        throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "The definition contains more than one multi-key " + "fields. The second multi-key field is " + step);
                    }
                    ipath.setMultiKeyPath(sb.toString(), ipath.getPosition());
                    ipath.setIsMapKey();
                    this.isMultiKeyMapIndex = true;
                    stepDef = FieldDefImpl.stringDef;
                    sb.append(".");
                    sb.append(step);
                    continue;
                }
                stepDef = stepDef.asMap().getElement();
                sb.append(".");
                sb.append(step);
                continue;
            }
            if (++stepIdx >= numSteps) break;
            step = steps.get(stepIdx);
            throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "There is no field named \"" + step + "\" after " + "path " + sb.toString());
        }
        if (!stepDef.isValidIndexField()) {
            throw new IllegalCommandException("Invalid index field definition : " + ipath + "\n" + "Cannot index values of type " + stepDef);
        }
        ipath.typeDef = (FieldDefImpl)stepDef;
        boolean nullable = (ipath.isComplex() || !this.table.isKeyComponent(ipath.getPathName()) && ipath.getFieldMap().getFieldMapEntry(ipath.getPathName()).isNullable()) && this.isNullSupported();
        ipath.setNullable(nullable);
        return stepDef;
    }

    public String toString() {
        return "Index[" + this.name + ", " + this.table.getId() + ", " + (Object)((Object)this.status) + "]";
    }

    public byte[] serializeIndexKey(RecordValueImpl record, int arrayIndex) {
        return this.serializeIndexKey(record, arrayIndex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] serializeIndexKey(RecordValueImpl record, int arrayIndex, boolean nullMultiKeyValue) {
        if (this.isMultiKeyMapIndex()) {
            if (!this.isNullSupported()) throw new IllegalStateException("Wrong serializer for map index");
            if (!nullMultiKeyValue) {
                throw new IllegalStateException("Wrong serializer for map index");
            }
        }
        TupleOutput out = null;
        try {
            out = new TupleOutput();
            int ind = 0;
            for (IndexField field : this.getIndexFields()) {
                NullValueImpl val;
                FieldValueImpl fieldValueImpl = val = field.isMultiKey() && nullMultiKeyValue ? NullValueImpl.getInstance() : record.findFieldValue(field.iterator(), arrayIndex);
                if (val == null) {
                    if (!this.isNullSupported()) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    val = NullValueImpl.getInstance();
                } else if (val.isNull() && !this.isNullSupported()) {
                    byte[] byArray = null;
                    return byArray;
                }
                IndexImpl.serializeValue(out, val, this.allowNull(ind++));
            }
            Object object = out.size() != 0 ? out.toByteArray() : null;
            return object;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] serializeIndexKey(RecordValueImpl record, String mapKey) {
        assert (this.isMultiKeyMapIndex());
        TupleOutput out = null;
        try {
            out = new TupleOutput();
            int ind = 0;
            for (IndexField field : this.getIndexFields()) {
                FieldValueImpl val = record.findFieldValue(field.iterator(), mapKey);
                if (val == null) {
                    if (!this.isNullSupported()) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    val = NullValueImpl.getInstance();
                } else if (val.isNull() && !this.isNullSupported()) {
                    byte[] byArray = null;
                    return byArray;
                }
                IndexImpl.serializeValue(out, val, this.allowNull(ind++));
            }
            Object object = out.size() != 0 ? out.toByteArray() : null;
            return object;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] serializeIndexKey(IndexKeyImpl indexKey) {
        return this.serializeIndexKey(indexKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeIndexKey(IndexKeyImpl indexKey, boolean includeNulls) {
        FieldValueImpl val;
        TupleOutput out = null;
        out = new TupleOutput();
        int numFields = this.indexKeyDef.getNumFields();
        for (int i = 0; i < numFields && (val = indexKey.get(i)) != null; ++i) {
            if (!(!val.isNull() || this.isNullSupported() && includeNulls)) {
                byte[] byArray = null;
                return byArray;
            }
            IndexImpl.serializeValue(out, val, this.allowNull(i) && includeNulls);
        }
        byte[] byArray = out.size() != 0 ? out.toByteArray() : null;
        return byArray;
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] reserializeToOldKey(byte[] indexKey) {
        IndexKeyImpl ikey = this.deserializeIndexKey(indexKey, false, true);
        return this.serializeIndexKey(ikey, false);
    }

    static TupleInput serializeValue(FieldValue value, boolean withNullIndicator) {
        TupleOutput output = new TupleOutput();
        IndexImpl.serializeValue(output, value, withNullIndicator);
        return new TupleInput(output);
    }

    private static void serializeValue(TupleOutput out, FieldValue val, boolean withNullIndicator) {
        if (withNullIndicator) {
            out.writeByte(IndexImpl.getSerializeNullIndicator(val));
            if (val == null || val.isNull()) {
                return;
            }
        }
        switch (val.getType()) {
            case INTEGER: {
                out.writeSortedPackedInt(val.asInteger().get());
                break;
            }
            case STRING: {
                out.writeString(val.asString().get());
                break;
            }
            case LONG: {
                out.writeSortedPackedLong(val.asLong().get());
                break;
            }
            case DOUBLE: {
                out.writeSortedDouble(val.asDouble().get());
                break;
            }
            case FLOAT: {
                out.writeSortedFloat(val.asFloat().get());
                break;
            }
            case NUMBER: {
                out.write(((NumberValueImpl)val).getBytes());
                break;
            }
            case ENUM: {
                out.writeSortedPackedInt(val.asEnum().getIndex());
                break;
            }
            case BOOLEAN: {
                out.writeBoolean(val.asBoolean().get());
                break;
            }
            case TIMESTAMP: {
                out.write(((TimestampValueImpl)val).getBytes(true));
                break;
            }
            default: {
                throw new IllegalStateException("Type not supported in indexes: " + val.getType());
            }
        }
    }

    public boolean isNullSupported() {
        return this.isNullSupported;
    }

    private static byte getSerializeNullIndicator(FieldValue val) {
        return val == null || val.isNull() ? (byte)1 : 0;
    }

    private static boolean isNullIndicator(byte indicator) {
        return indicator == 1;
    }

    boolean allowNull(int idxField) {
        return this.indexFields.get(idxField).isNullable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowFromIndexKey(byte[] data, RowImpl row) {
        TupleInput input = null;
        try {
            input = new TupleInput(data);
            int ind = 0;
            block10: for (IndexField ifield : this.getIndexFields()) {
                byte in;
                if (input.available() <= 0) {
                    break;
                }
                if (this.allowNull(ind++) && IndexImpl.isNullIndicator(in = input.readByte())) {
                    row.putComplex(ifield.iterator(), NullValueImpl.getInstance());
                    continue;
                }
                FieldDefImpl def = ifield.getTypeDef();
                switch (def.getType()) {
                    case INTEGER: 
                    case STRING: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case NUMBER: 
                    case ENUM: 
                    case BOOLEAN: 
                    case TIMESTAMP: {
                        FieldValue val = def.createValue(FieldValueImpl.readTuple(def, input));
                        row.putComplex(ifield.iterator(), val);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Type not supported in indexes: " + def.getType());
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public IndexKeyImpl deserializeIndexKey(byte[] data, boolean partialOK) {
        return this.deserializeIndexKey(data, partialOK, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexKeyImpl deserializeIndexKey(byte[] data, boolean partialOK, boolean mayIncludeNulls) {
        TupleInput input = null;
        IndexKeyImpl indexKey = new IndexKeyImpl(this, this.indexKeyDef);
        try {
            input = new TupleInput(data);
            int numFields = this.indexKeyDef.getNumFields();
            block10: for (int i = 0; i < numFields && input.available() > 0; ++i) {
                byte in;
                if (mayIncludeNulls && this.allowNull(i) && IndexImpl.isNullIndicator(in = input.readByte())) {
                    indexKey.putNull(i);
                    continue;
                }
                FieldDefImpl def = this.indexKeyDef.getFieldDef(i);
                switch (def.getType()) {
                    case INTEGER: 
                    case STRING: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case NUMBER: 
                    case ENUM: 
                    case BOOLEAN: 
                    case TIMESTAMP: {
                        FieldValue val = def.createValue(FieldValueImpl.readTuple(def, input));
                        indexKey.put(i, val);
                        continue block10;
                    }
                    default: {
                        throw new IllegalStateException("Type not supported in indexes: " + def.getType());
                    }
                }
            }
            if (!partialOK && !indexKey.isComplete()) {
                throw new IllegalStateException("Missing fields from index data for index " + this.getName() + ", expected " + numFields + ", received " + indexKey.size());
            }
            IndexKeyImpl indexKeyImpl = indexKey;
            return indexKeyImpl;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isIndexField(TablePath path) {
        for (IndexField iField : this.getIndexFields()) {
            if (!iField.equals(path)) continue;
            return true;
        }
        return false;
    }

    boolean containsField(String fieldName) {
        String fname = fieldName.toLowerCase();
        for (IndexField indexField : this.getIndexFields()) {
            if (!(indexField.isComplex() ? indexField.getPathName().contains(fname) : indexField.getPathName().equals(fname))) continue;
            return true;
        }
        return false;
    }

    public static List<String> translateFields(List<String> fieldList) {
        ArrayList<String> newList = new ArrayList<String>(fieldList.size());
        for (String field : fieldList) {
            if (field == null) {
                return fieldList;
            }
            String newField = TableImpl.translateFromExternalField(field);
            if (newField == null) {
                return fieldList;
            }
            newList.add(newField);
        }
        return newList;
    }

    private RecordDefImpl createRecordDef() {
        FieldMap fieldMap = new FieldMap();
        for (IndexField indexField : this.getIndexFields()) {
            FieldDefImpl def = indexField.getTypeDef();
            String translatedName = indexField.getPathName();
            FieldMapEntry fme = new FieldMapEntry(translatedName, def);
            fieldMap.put(fme);
        }
        return new RecordDefImpl(fieldMap, null);
    }

    @Override
    public Index.IndexType getType() {
        if (this.annotations == null) {
            return Index.IndexType.SECONDARY;
        }
        return Index.IndexType.TEXT;
    }

    private boolean isTextIndex() {
        return this.getType() == Index.IndexType.TEXT;
    }

    @Override
    public String getAnnotationForField(String fieldName) {
        if (!this.isTextIndex()) {
            return null;
        }
        return this.annotations.get(fieldName);
    }

    public RowImpl deserializeRow(byte[] keyBytes, byte[] valueBytes) {
        return this.table.createRowFromBytes(keyBytes, valueBytes, false);
    }

    private boolean isEnableNullSupported() {
        return !Boolean.getBoolean(INDEX_NULL_DISABLE);
    }

    static int compareUnsignedBytes(byte[] key1, int off1, int len1, byte[] key2, int off2, int len2) {
        int limit = Math.min(len1, len2);
        for (int i = 0; i < limit; ++i) {
            byte b1 = key1[i + off1];
            byte b2 = key2[i + off2];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return len1 - len2;
    }

    static int compareUnsignedBytes(byte[] key1, byte[] key2) {
        return IndexImpl.compareUnsignedBytes(key1, 0, key1.length, key2, 0, key2.length);
    }

    public static class AnnotatedField
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final String annotation;

        public AnnotatedField(String fieldName, String annotation) {
            assert (fieldName != null);
            this.fieldName = fieldName;
            this.annotation = annotation;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotatedField other = (AnnotatedField)obj;
            if (!this.fieldName.equals(other.fieldName)) {
                return false;
            }
            return this.annotation == null ? other.annotation == null : JsonUtils.jsonStringsEqual(this.annotation, other.annotation);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fieldName.hashCode();
            if (this.annotation != null) {
                result = 31 * result + this.annotation.hashCode();
            }
            return result;
        }
    }

    public static class IndexField
    extends TablePath {
        private IndexField multiKeyField;
        private MultiKeyType multiKeyType = MultiKeyType.NONE;
        private final int position;
        private FieldDefImpl typeDef;
        private boolean nullable;

        public IndexField(TableImpl table, String field, int position) {
            super(table, field);
            this.position = position;
        }

        private IndexField(FieldMap fieldMap, String field, int position) {
            super(fieldMap, field);
            this.position = position;
        }

        IndexField getMultiKeyField() {
            return this.multiKeyField;
        }

        public boolean isMultiKey() {
            return this.multiKeyField != null;
        }

        public int getPosition() {
            return this.position;
        }

        public FieldDefImpl getTypeDef() {
            return this.typeDef;
        }

        public void setTypeDef(FieldDefImpl def) {
            this.typeDef = def;
        }

        boolean isNullable() {
            return this.nullable;
        }

        private void setMultiKeyPath(String path, int position) {
            this.multiKeyField = new IndexField(this.getFieldMap(), path, position);
        }

        public boolean isMapKey() {
            return this.multiKeyType == MultiKeyType.MAPKEY;
        }

        private void setIsMapKey() {
            this.multiKeyType = MultiKeyType.MAPKEY;
        }

        public boolean isMapValue() {
            return this.multiKeyType == MultiKeyType.MAPVALUE;
        }

        private void setIsMapValue() {
            this.multiKeyType = MultiKeyType.MAPVALUE;
        }

        private void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        private static enum MultiKeyType {
            NONE,
            MAPKEY,
            MAPVALUE;

        }
    }

    public static enum IndexStatus {
        TRANSIENT{

            @Override
            public boolean isTransient() {
                return true;
            }
        }
        ,
        POPULATING{

            @Override
            public boolean isPopulating() {
                return true;
            }
        }
        ,
        READY{

            @Override
            public boolean isReady() {
                return true;
            }
        };


        public boolean isTransient() {
            return false;
        }

        public boolean isPopulating() {
            return false;
        }

        public boolean isReady() {
            return false;
        }
    }
}

