/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordValue;

public class FieldValueSerialization {
    private static final int NULL_VALUE = -1;
    private static final int NULL_REFERENCE = -2;
    private static final int NULL_JSON_VALUE = -3;

    public static void writeFieldValue(FieldValue val, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        if (val == null) {
            out.writeByte(-2);
        } else if (val.isNull()) {
            out.writeByte(-1);
        } else if (val.isJsonNull()) {
            out.writeByte(-3);
        } else {
            val.getType().writeFastExternal(out, serialVersion);
            FieldValueSerialization.writeFieldValue(val, writeValDef, false, out, serialVersion);
        }
    }

    public static void writeFieldValue(FieldValue val, boolean writeValDef, boolean writeValKind, DataOutput out, short serialVersion) throws IOException {
        assert (val != null);
        assert (!val.isNull());
        FieldValueImpl value = (FieldValueImpl)val;
        FieldDefImpl valDef = (FieldDefImpl)val.getDefinition();
        if (valDef.isWildcard() && !val.isJsonNull()) {
            throw new IllegalStateException("An item cannot have a wildcard type\n" + val);
        }
        if (valDef.getType() != value.getType()) {
            throw new IllegalStateException("Mismatch between value kind and associated type\nValue kind : " + val.getType() + "\n" + "Type : " + valDef);
        }
        if (writeValDef && writeValKind) {
            if (val.isJsonNull()) {
                out.writeByte(-3);
                return;
            }
            val.getType().writeFastExternal(out, serialVersion);
        }
        switch (val.getType()) {
            case INTEGER: {
                SerializationUtil.writePackedInt(out, value.getInt());
                break;
            }
            case LONG: {
                SerializationUtil.writePackedLong(out, value.getLong());
                break;
            }
            case DOUBLE: {
                out.writeDouble(value.getDouble());
                break;
            }
            case FLOAT: {
                out.writeFloat(value.getFloat());
                break;
            }
            case STRING: {
                out.writeUTF(value.getString());
                break;
            }
            case BOOLEAN: {
                out.writeBoolean(value.getBoolean());
                break;
            }
            case NUMBER: {
                byte[] bytes = value.getBytes();
                SerializationUtil.writePackedInt(out, bytes.length);
                out.write(bytes);
                break;
            }
            case BINARY: {
                byte[] bytes = value.getBytes();
                SerializationUtil.writePackedInt(out, bytes.length);
                if (bytes.length <= 0) break;
                out.write(bytes);
                break;
            }
            case FIXED_BINARY: {
                int size = ((FixedBinaryDefImpl)valDef).getSize();
                SerializationUtil.writePackedInt(out, size);
                byte[] bytes = value.getBytes();
                assert (bytes.length == size);
                out.write(bytes);
                break;
            }
            case ENUM: {
                if (writeValDef) {
                    FieldDefImpl def = value.getDefinition();
                    FieldDefSerialization.writeEnum(def, out, serialVersion);
                }
                out.writeShort(value.asEnum().getIndex());
                break;
            }
            case TIMESTAMP: {
                if (writeValDef) {
                    FieldDefImpl def = value.getDefinition();
                    FieldDefSerialization.writeTimestamp(def, out, serialVersion);
                }
                byte[] bytes = ((TimestampValueImpl)value).getBytes();
                assert (bytes.length > 0);
                out.writeByte(bytes.length);
                out.write(bytes);
                break;
            }
            case RECORD: {
                FieldValueSerialization.writeRecord(value, writeValDef, out, serialVersion);
                break;
            }
            case MAP: {
                FieldValueSerialization.writeMap(value, writeValDef, out, serialVersion);
                break;
            }
            case ARRAY: {
                FieldValueSerialization.writeArray(value, writeValDef, out, serialVersion);
                break;
            }
            case ANY: 
            case ANY_ATOMIC: 
            case ANY_JSON_ATOMIC: 
            case ANY_RECORD: {
                throw new IllegalStateException("ANY* types cannot be materialized as values");
            }
            case JSON: {
                throw new IllegalStateException("JSON cannot be materialized as a value");
            }
            case EMPTY: {
                throw new IllegalStateException("EMPTY type does not contain any values");
            }
        }
    }

    private static void writeRecord(FieldValueImpl val, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        RecordDefImpl recordDef = (RecordDefImpl)val.getDefinition();
        RecordValueImpl record = (RecordValueImpl)val;
        if (writeValDef) {
            FieldDefSerialization.writeRecord(recordDef, out, serialVersion);
        }
        for (int pos = 0; pos < recordDef.getNumFields(); ++pos) {
            FieldDefImpl fdef = recordDef.getFieldDef(pos);
            FieldValueImpl fval = record.get(pos);
            if (!recordDef.isNullable(pos)) {
                FieldValueSerialization.writeFieldValue(fval, fdef.isWildcard(), true, out, serialVersion);
                continue;
            }
            FieldValueSerialization.writeFieldValue(fval, fdef.isWildcard(), out, serialVersion);
        }
    }

    private static void writeMap(FieldValueImpl value, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        MapValueImpl map = (MapValueImpl)value.asMap();
        MapDefImpl mapDef = map.getDefinition();
        FieldDefImpl elemDef = (FieldDefImpl)mapDef.getElement();
        boolean wildcard = elemDef.isWildcard();
        if (writeValDef) {
            FieldDefSerialization.writeFieldDef(elemDef, out, serialVersion);
        }
        int size = map.size();
        SerializationUtil.writePackedInt(out, size);
        if (size == 0) {
            return;
        }
        for (Map.Entry<String, FieldValue> entry : map.getFieldsInternal().entrySet()) {
            out.writeUTF(entry.getKey());
            FieldValueSerialization.writeFieldValue(entry.getValue(), wildcard, true, out, serialVersion);
        }
    }

    private static void writeArray(FieldValueImpl value, boolean writeValDef, DataOutput out, short serialVersion) throws IOException {
        boolean homogeneous;
        ArrayValueImpl array = (ArrayValueImpl)value.asArray();
        FieldDefImpl elemDef = array.getElementDef();
        FieldDefImpl homogeneousType = array.getHomogeneousType();
        boolean wildcard = elemDef.isWildcard();
        boolean bl = homogeneous = homogeneousType != null;
        if (writeValDef) {
            FieldDefSerialization.writeFieldDef(elemDef, out, serialVersion);
        }
        if (serialVersion >= 12 && wildcard) {
            out.writeBoolean(homogeneous);
            if (homogeneous) {
                FieldDefSerialization.writeFieldDef(homogeneousType, out, serialVersion);
                wildcard = false;
            }
        }
        int size = array.size();
        SerializationUtil.writePackedInt(out, size);
        if (size == 0) {
            return;
        }
        for (FieldValue fieldVal : array.getArrayInternal()) {
            FieldValueSerialization.writeFieldValue(fieldVal, wildcard, true, out, serialVersion);
        }
    }

    public static FieldValue readFieldValue(FieldDef def, DataInput in, short serialVersion) throws IOException {
        byte ordinal = in.readByte();
        if (ordinal == -2) {
            return null;
        }
        if (ordinal == -1) {
            return NullValueImpl.getInstance();
        }
        if (ordinal == -3) {
            return NullJsonValueImpl.getInstance();
        }
        FieldDef.Type valKind = FieldDef.Type.values()[ordinal];
        return FieldValueSerialization.readFieldValue(def, valKind, in, serialVersion);
    }

    public static FieldValue readFieldValue(FieldDef def, FieldDef.Type valKind, DataInput in, short serialVersion) throws IOException {
        if (def == null) {
            if (valKind == null) {
                byte ordinal = in.readByte();
                if (ordinal == -3) {
                    return NullJsonValueImpl.getInstance();
                }
                valKind = FieldDef.Type.values()[ordinal];
            }
        } else if (valKind == null) {
            valKind = def.getType();
        }
        switch (valKind) {
            case INTEGER: {
                int val = SerializationUtil.readPackedInt(in);
                return FieldDefImpl.integerDef.createInteger(val);
            }
            case LONG: {
                long val = SerializationUtil.readPackedLong(in);
                return FieldDefImpl.longDef.createLong(val);
            }
            case DOUBLE: {
                double val = in.readDouble();
                return FieldDefImpl.doubleDef.createDouble(val);
            }
            case FLOAT: {
                float val = in.readFloat();
                return FieldDefImpl.floatDef.createFloat(val);
            }
            case STRING: {
                String val = in.readUTF();
                return FieldDefImpl.stringDef.createString(val);
            }
            case BOOLEAN: {
                return FieldDefImpl.booleanDef.createBoolean(in.readBoolean());
            }
            case NUMBER: {
                int len = SerializationUtil.readPackedInt(in);
                assert (len > 0);
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                return FieldDefImpl.numberDef.createNumber(bytes);
            }
            case BINARY: {
                int len = SerializationUtil.readPackedInt(in);
                byte[] bytes = new byte[len];
                if (len > 0) {
                    in.readFully(bytes);
                }
                return FieldDefImpl.binaryDef.createBinary(bytes);
            }
            case FIXED_BINARY: {
                int len = SerializationUtil.readPackedInt(in);
                byte[] bytes = new byte[len];
                if (len > 0) {
                    in.readFully(bytes);
                }
                return new FixedBinaryDefImpl(len, null).createFixedBinary(bytes);
            }
            case ENUM: {
                EnumDefImpl enumDef;
                EnumDefImpl enumDefImpl = enumDef = def == null ? FieldDefSerialization.readEnum(in, serialVersion) : (EnumDefImpl)def;
                assert (enumDef != null);
                short index = in.readShort();
                return enumDef.createEnum(index);
            }
            case TIMESTAMP: {
                TimestampDefImpl timestampDef;
                TimestampDefImpl timestampDefImpl = timestampDef = def == null ? FieldDefSerialization.readTimestamp(in, serialVersion) : (TimestampDefImpl)def;
                assert (timestampDef != null);
                byte len = in.readByte();
                assert (len > 0);
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                return timestampDef.createTimestamp(bytes);
            }
            case RECORD: {
                return FieldValueSerialization.readRecord(def, in, serialVersion);
            }
            case MAP: {
                return FieldValueSerialization.readMap(def, in, serialVersion);
            }
            case ARRAY: {
                return FieldValueSerialization.readArray(def, in, serialVersion);
            }
        }
        throw new IllegalStateException("Type not supported: " + valKind);
    }

    static RecordValue readRecord(FieldDef def, DataInput in, short serialVersion) throws IOException {
        RecordDefImpl recordDef = def == null ? FieldDefSerialization.readRecord(in, serialVersion) : (RecordDefImpl)def;
        RecordValueImpl record = recordDef.createRecord();
        for (int pos = 0; pos < recordDef.getNumFields(); ++pos) {
            FieldDefImpl fdef = recordDef.getFieldDef(pos);
            if (fdef.isWildcard()) {
                fdef = null;
            }
            FieldValue fval = null;
            fval = fdef != null && !recordDef.isNullable(pos) ? FieldValueSerialization.readFieldValue(fdef, fdef.getType(), in, serialVersion) : FieldValueSerialization.readFieldValue(fdef, in, serialVersion);
            if (fval == null) continue;
            record.putInternal(pos, fval);
        }
        return record;
    }

    static MapValue readMap(FieldDef def, DataInput in, short serialVersion) throws IOException {
        FieldDefImpl elemDef = null;
        MapDef mapDef = null;
        if (def != null) {
            mapDef = def.asMap();
            elemDef = (FieldDefImpl)mapDef.getElement();
        } else {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            mapDef = FieldDefFactory.createMapDef(elemDef);
        }
        MapValueImpl map = (MapValueImpl)mapDef.createMap();
        boolean wildcard = elemDef.isWildcard();
        if (wildcard) {
            elemDef = null;
        }
        int size = SerializationUtil.readPackedInt(in);
        for (int i = 0; i < size; ++i) {
            String fname = in.readUTF();
            FieldValue fval = FieldValueSerialization.readFieldValue(elemDef, null, in, serialVersion);
            assert (fval.isNull() || elemDef == null || fval.getType() == elemDef.getType());
            assert (!fval.isNull());
            map.put(fname, fval);
        }
        return map;
    }

    static ArrayValue readArray(FieldDef def, DataInput in, short serialVersion) throws IOException {
        boolean homogeneous;
        boolean wildcard;
        ArrayDefImpl arrayDef = null;
        FieldDefImpl elemDef = null;
        if (def != null) {
            arrayDef = (ArrayDefImpl)def;
            elemDef = arrayDef.getElement();
            wildcard = elemDef.isWildcard();
        } else {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            arrayDef = FieldDefFactory.createArrayDef(elemDef);
            wildcard = elemDef.isWildcard();
        }
        ArrayValueImpl array = arrayDef.createArray();
        if (serialVersion >= 12 && wildcard && (homogeneous = in.readBoolean())) {
            elemDef = FieldDefSerialization.readFieldDef(in, serialVersion);
            array.setHomogeneousType(elemDef);
            wildcard = false;
        }
        if (wildcard) {
            elemDef = null;
        }
        int size = SerializationUtil.readPackedInt(in);
        for (int i = 0; i < size; ++i) {
            FieldValue fval = FieldValueSerialization.readFieldValue(elemDef, null, in, serialVersion);
            assert (elemDef == null || fval.getType() == elemDef.getType());
            array.add(fval);
        }
        return array;
    }
}

